/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.libraries.nbt;

import java.io.DataInput;
import java.io.IOException;
import java.util.HashMap;
import net.momirealms.craftengine.libraries.nbt.ByteArrayTag;
import net.momirealms.craftengine.libraries.nbt.ByteTag;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import net.momirealms.craftengine.libraries.nbt.DoubleTag;
import net.momirealms.craftengine.libraries.nbt.EndTag;
import net.momirealms.craftengine.libraries.nbt.FloatTag;
import net.momirealms.craftengine.libraries.nbt.IntArrayTag;
import net.momirealms.craftengine.libraries.nbt.IntTag;
import net.momirealms.craftengine.libraries.nbt.ListTag;
import net.momirealms.craftengine.libraries.nbt.LongArrayTag;
import net.momirealms.craftengine.libraries.nbt.LongTag;
import net.momirealms.craftengine.libraries.nbt.ShortTag;
import net.momirealms.craftengine.libraries.nbt.StringTag;
import net.momirealms.craftengine.libraries.nbt.Tag;
import net.momirealms.craftengine.libraries.nbt.TagType;

public class TagTypes {
    public static final TagType<EndTag> END = new TagType<EndTag>(){

        @Override
        public String name() {
            return "End";
        }

        @Override
        public void skip(DataInput input, int count) {
        }

        @Override
        public void skip(DataInput input) {
        }

        @Override
        public EndTag read(DataInput input, int depth) {
            return EndTag.INSTANCE;
        }
    };
    public static final TagType<ByteTag> BYTE = new TagType.FixedSize<ByteTag>(){

        @Override
        public String name() {
            return "Byte";
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public ByteTag read(DataInput input, int depth) throws IOException {
            return new ByteTag(input.readByte());
        }

        @Override
        public boolean isValue() {
            return true;
        }
    };
    public static final TagType<DoubleTag> DOUBLE = new TagType.FixedSize<DoubleTag>(){

        @Override
        public DoubleTag read(DataInput dataInput, int depth) throws IOException {
            return new DoubleTag(dataInput.readDouble());
        }

        @Override
        public int size() {
            return 8;
        }

        @Override
        public String name() {
            return "Double";
        }

        @Override
        public boolean isValue() {
            return true;
        }
    };
    public static final TagType<FloatTag> FLOAT = new TagType.FixedSize<FloatTag>(){

        @Override
        public FloatTag read(DataInput dataInput, int depth) throws IOException {
            return new FloatTag(dataInput.readFloat());
        }

        @Override
        public int size() {
            return 4;
        }

        @Override
        public String name() {
            return "Float";
        }

        @Override
        public boolean isValue() {
            return true;
        }
    };
    public static final TagType<LongTag> LONG = new TagType.FixedSize<LongTag>(){

        @Override
        public LongTag read(DataInput dataInput, int depth) throws IOException {
            return new LongTag(dataInput.readLong());
        }

        @Override
        public int size() {
            return 8;
        }

        @Override
        public String name() {
            return "Long";
        }

        @Override
        public boolean isValue() {
            return true;
        }
    };
    public static final TagType<IntTag> INT = new TagType.FixedSize<IntTag>(){

        @Override
        public IntTag read(DataInput dataInput, int depth) throws IOException {
            return new IntTag(dataInput.readInt());
        }

        @Override
        public int size() {
            return 4;
        }

        @Override
        public String name() {
            return "Int";
        }

        @Override
        public boolean isValue() {
            return true;
        }
    };
    public static final TagType<ShortTag> SHORT = new TagType.FixedSize<ShortTag>(){

        @Override
        public ShortTag read(DataInput dataInput, int depth) throws IOException {
            return new ShortTag(dataInput.readShort());
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public String name() {
            return "Short";
        }

        @Override
        public boolean isValue() {
            return true;
        }
    };
    public static final TagType<StringTag> STRING = new TagType.FlexibleSize<StringTag>(){

        @Override
        public StringTag read(DataInput dataInput, int depth) throws IOException {
            String string = dataInput.readUTF();
            return new StringTag(string);
        }

        @Override
        public void skip(DataInput input) throws IOException {
            StringTag.skipString(input);
        }

        @Override
        public String name() {
            return "String";
        }

        @Override
        public boolean isValue() {
            return true;
        }
    };
    public static final TagType<IntArrayTag> INT_ARRAY = new TagType.FlexibleSize<IntArrayTag>(){

        @Override
        public IntArrayTag read(DataInput input, int depth) throws IOException {
            int i = input.readInt();
            int[] array = new int[i];
            for (int k = 0; k < i; ++k) {
                array[k] = input.readInt();
            }
            return new IntArrayTag(array);
        }

        @Override
        public void skip(DataInput input) throws IOException {
            input.skipBytes(input.readInt() * 4);
        }

        @Override
        public String name() {
            return "Int[]";
        }
    };
    public static final TagType<ByteArrayTag> BYTE_ARRAY = new TagType.FlexibleSize<ByteArrayTag>(){

        @Override
        public ByteArrayTag read(DataInput input, int depth) throws IOException {
            int i = input.readInt();
            byte[] array = new byte[i];
            input.readFully(array);
            return new ByteArrayTag(array);
        }

        @Override
        public void skip(DataInput input) throws IOException {
            input.skipBytes(input.readInt());
        }

        @Override
        public String name() {
            return "Byte[]";
        }
    };
    public static final TagType<LongArrayTag> LONG_ARRAY = new TagType.FlexibleSize<LongArrayTag>(){

        @Override
        public LongArrayTag read(DataInput dataInput, int depth) throws IOException {
            int i = dataInput.readInt();
            long[] array = new long[i];
            for (int k = 0; k < i; ++k) {
                array[k] = dataInput.readLong();
            }
            return new LongArrayTag(array);
        }

        @Override
        public void skip(DataInput input) throws IOException {
            input.skipBytes(input.readInt() * 8);
        }

        @Override
        public String name() {
            return "Long[]";
        }
    };
    public static final TagType<ListTag> LIST = new TagType.FlexibleSize<ListTag>(){

        @Override
        public ListTag read(DataInput dataInput, int depth) throws IOException {
            if (depth > 512) {
                throw new RuntimeException("Tried to read NBT tag with too high complexity, depth > 512");
            }
            byte typeId = dataInput.readByte();
            int length = dataInput.readInt();
            if (typeId == 0 && length > 0) {
                throw new RuntimeException("Missing type on ListTag");
            }
            TagType<?> tagType = TagTypes.typeById(typeId);
            ListTag listTag = new ListTag();
            for (int k = 0; k < length; ++k) {
                listTag.addAndUnwrap((Tag)tagType.read(dataInput, depth + 1));
            }
            return listTag;
        }

        @Override
        public void skip(DataInput input) throws IOException {
            TagType<?> tagType = TagTypes.typeById(input.readByte());
            int i = input.readInt();
            tagType.skip(input, i);
        }

        @Override
        public String name() {
            return "List";
        }
    };
    public static final TagType<CompoundTag> COMPOUND = new TagType.FlexibleSize<CompoundTag>(){

        @Override
        public CompoundTag read(DataInput dataInput, int depth) throws IOException {
            byte typeId;
            if (depth > 512) {
                throw new RuntimeException("Tried to read NBT tag with too high complexity, depth > 512");
            }
            HashMap<String, Tag> map = new HashMap<String, Tag>(8, 0.8f);
            while ((typeId = CompoundTag.readNamedTagType(dataInput)) != 0) {
                String string = CompoundTag.readNamedTagName(dataInput);
                Tag tag = CompoundTag.readNamedTagData(TagTypes.typeById(typeId), dataInput, depth + 1);
                map.put(string, tag);
            }
            return new CompoundTag(map);
        }

        @Override
        public void skip(DataInput input) throws IOException {
            byte typeId;
            while ((typeId = input.readByte()) != 0) {
                StringTag.skipString(input);
                TagTypes.typeById(typeId).skip(input);
            }
        }

        @Override
        public String name() {
            return "Compound";
        }
    };
    private static final TagType<?>[] TYPES = new TagType[]{END, BYTE, SHORT, INT, LONG, FLOAT, DOUBLE, BYTE_ARRAY, STRING, LIST, COMPOUND, INT_ARRAY, LONG_ARRAY};

    private TagTypes() {
    }

    public static TagType<?> typeById(int id) {
        return TYPES[id];
    }
}

