/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.libraries.nbt.visitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.StringJoiner;
import net.momirealms.craftengine.libraries.nbt.ByteArrayTag;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import net.momirealms.craftengine.libraries.nbt.IntArrayTag;
import net.momirealms.craftengine.libraries.nbt.ListTag;
import net.momirealms.craftengine.libraries.nbt.LongArrayTag;
import net.momirealms.craftengine.libraries.nbt.Tag;
import net.momirealms.craftengine.libraries.nbt.visitor.CompactStringTagVisitor;

public class PrettyStringTagVisitor
extends CompactStringTagVisitor {
    @Override
    public void visitByteArray(ByteArrayTag element) {
        this.builder.append("[");
        byte[] array = element.getAsByteArray();
        StringJoiner joiner = new StringJoiner(", ");
        byte[] byArray = array;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            long l = byArray[i];
            joiner.add(String.valueOf(l));
        }
        this.builder.append(joiner);
        this.builder.append(']');
    }

    @Override
    public void visitIntArray(IntArrayTag element) {
        this.builder.append("[");
        int[] array = element.getAsIntArray();
        StringJoiner joiner = new StringJoiner(", ");
        int[] nArray = array;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            long l = nArray[i];
            joiner.add(String.valueOf(l));
        }
        this.builder.append(joiner);
        this.builder.append(']');
    }

    @Override
    public void visitLongArray(LongArrayTag element) {
        this.builder.append("[");
        long[] array = element.getAsLongArray();
        StringJoiner joiner = new StringJoiner(", ");
        for (long l : array) {
            joiner.add(String.valueOf(l));
        }
        this.builder.append(joiner);
        this.builder.append(']');
    }

    @Override
    public void visitList(ListTag element) {
        this.builder.append("[\r\n");
        StringJoiner joiner = new StringJoiner(",\r\n");
        for (Tag tag : element) {
            joiner.add("   " + new PrettyStringTagVisitor().visit(tag).replaceAll("\r\n", "\r\n   "));
        }
        this.builder.append(joiner);
        this.builder.append("\r\n]");
    }

    @Override
    public void visitCompound(CompoundTag compound) {
        this.builder.append("{\r\n");
        ArrayList<String> list = new ArrayList<String>(compound.keySet());
        Collections.sort(list);
        StringJoiner joiner = new StringJoiner(",\r\n");
        for (String string : list) {
            Tag tag = Objects.requireNonNull(compound.get(string));
            joiner.add("   " + tag.getType().name() + "(\"" + PrettyStringTagVisitor.handleEscape(string) + "\"): " + new PrettyStringTagVisitor().visit(tag).replaceAll("\r\n", "\r\n   "));
        }
        this.builder.append(joiner);
        this.builder.append("\r\n}");
    }
}

