/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickauth.shadow.de.clickism.configured;

import de.clickism.clickauth.shadow.de.clickism.configured.ConfigOption;
import de.clickism.clickauth.shadow.de.clickism.configured.Configured;
import de.clickism.clickauth.shadow.de.clickism.configured.format.ConfigFormat;
import de.clickism.clickauth.shadow.de.clickism.configured.format.ConfigFormatProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Config {
    private static final ConfigOption<Integer> VERSION_OPTION = ConfigOption.ofObject("_version", 0);
    private final ConfigFormat format;
    private final Set<ConfigOption<?>> options = new LinkedHashSet();
    @Nullable
    private File file;
    @Nullable
    private Integer version;
    private Map<String, Object> data = new HashMap<String, Object>();
    @Nullable
    private String header;
    @Nullable
    private String footer;
    @Nullable
    private Function<String, String> oldKeyGenerator;

    public Config(@Nullable File file, ConfigFormat format) {
        this.format = format;
        this.file = file;
    }

    public static Config of(@NotNull File file) {
        ConfigFormat format = ConfigFormatProvider.getFormat(file.getPath(), ConfigFormatProvider.getCallerClass());
        return new Config(file, format);
    }

    public static Config of(@NotNull String filePath) {
        return Config.of(new File(filePath));
    }

    public static Config of(@Nullable File file, ConfigFormat format) {
        return new Config(file, format);
    }

    public static Config of(@NotNull String filePath, ConfigFormat format) {
        return Config.of(new File(filePath), format);
    }

    public <T> ConfigOption<T> optionOfObject(String key, T defaultValue) {
        return this.register(ConfigOption.ofObject(key, defaultValue));
    }

    public ConfigOption<Boolean> optionOf(String key, boolean defaultValue) {
        return this.register(ConfigOption.of(key, defaultValue));
    }

    public <T extends Number> ConfigOption<T> optionOf(String key, T defaultValue) {
        return this.register(ConfigOption.of(key, defaultValue));
    }

    public ConfigOption<String> optionOf(String key, String defaultValue) {
        return this.register(ConfigOption.of(key, defaultValue));
    }

    public ConfigOption<Character> optionOf(String key, char defaultValue) {
        return this.register(ConfigOption.of(key, defaultValue));
    }

    public <T> ConfigOption<List<T>> optionOf(String key, List<T> defaultValue, Class<T> elementType) {
        return this.register(ConfigOption.of(key, defaultValue, elementType));
    }

    public <T> ConfigOption<Set<T>> optionOf(String key, Set<T> defaultValue, Class<T> elementType) {
        return this.register(ConfigOption.of(key, defaultValue, elementType));
    }

    public <K, V> ConfigOption<Map<K, V>> optionOf(String key, Map<K, V> defaultValue, Class<K> keyType, Class<V> valueType) {
        return this.register(ConfigOption.of(key, defaultValue, keyType, valueType));
    }

    public <T> ConfigOption<T> register(ConfigOption<T> option) {
        if (this.options.contains(option)) {
            throw new IllegalArgumentException("Option with key '" + option.key() + "' already exists");
        }
        this.options.add(option);
        this.data.put(option.key(), option.defaultValue());
        return option;
    }

    public Config registerAll(Collection<ConfigOption<?>> options) {
        for (ConfigOption<?> option : options) {
            this.register(option);
        }
        return this;
    }

    public <T> T get(ConfigOption<T> option) {
        Object value = this.data.get(option.key());
        if (value == null) {
            return option.defaultValue();
        }
        try {
            return (T)value;
        }
        catch (ClassCastException ignored) {
            Configured.LOGGER.warning("Invalid value type for option '" + option.key() + "'. Using default value instead");
            return option.defaultValue();
        }
    }

    @Nullable
    public <T> T getOrNull(ConfigOption<T> option) {
        Object value = this.data.get(option.key());
        if (value == null) {
            return null;
        }
        try {
            return (T)value;
        }
        catch (ClassCastException ignored) {
            Configured.LOGGER.warning("Invalid value type for option '" + option.key() + "'.");
            return null;
        }
    }

    public <T> Config set(ConfigOption<T> option, @Nullable T value) {
        if (!this.options.contains(option)) {
            throw new IllegalArgumentException("Option '" + option.key() + "' is not registered");
        }
        if (value == null) {
            this.data.remove(option.key());
            return this;
        }
        this.data.put(option.key(), value);
        return this;
    }

    public void reset(ConfigOption<?> option) {
        this.set(option, null);
    }

    public Config load() {
        this.loadInternal(true, true);
        return this;
    }

    public Config loadWithoutUpdating() {
        this.loadInternal(true, false);
        return this;
    }

    public Config loadIfExists() {
        this.loadInternal(false, true);
        return this;
    }

    public Config loadIfExistsWithoutUpdating() {
        this.loadInternal(false, false);
        return this;
    }

    private void loadInternal(boolean create, boolean update) {
        if (this.file == null) {
            Configured.LOGGER.severe("No file specified for config!");
            return;
        }
        try {
            if (!this.file.exists()) {
                if (create) {
                    this.save();
                }
                this.callListeners();
                return;
            }
            Map<String, Object> data = this.format.read(this.file);
            this.castAllData(data);
            this.data = data;
            if (this.isVersionMismatch() && update) {
                Configured.LOGGER.info("Config file '" + this.file.getPath() + "' has a different version. Saving current version.");
                this.save();
            }
            this.callListeners();
        }
        catch (Exception e) {
            Configured.LOGGER.log(Level.SEVERE, "Failed to load config file: " + this.file.getAbsolutePath(), e);
        }
    }

    private void castAllData(Map<String, Object> data) {
        for (ConfigOption<?> option : this.options) {
            String key = option.key();
            Object value = data.get(key);
            if (value == null && (value = this.getValueOfOldKey(option, data)) == null) continue;
            try {
                data.put(key, option.cast(value));
            }
            catch (ClassCastException e) {
                Configured.LOGGER.warning("Invalid value type for option '" + key + "'. Using default value instead. Reason: " + e.getMessage());
                data.put(key, option.defaultValue());
            }
        }
    }

    @Nullable
    private Object getValueOfOldKey(ConfigOption<?> option, Map<String, Object> data) {
        Object value = null;
        ArrayList<String> oldKeys = new ArrayList<String>(option.oldKeys());
        String generatedOldKey = this.generateOldKey(option);
        if (generatedOldKey != null) {
            oldKeys.add(generatedOldKey);
        }
        for (String oldKey : oldKeys) {
            value = data.get(oldKey);
            if (value == null) continue;
            Configured.LOGGER.warning("Found old key '" + oldKey + "' for option '" + option.key() + "'. Loading from it...");
            break;
        }
        return value;
    }

    private Config callListeners() {
        for (ConfigOption<?> option : this.options) {
            if (!this.data.containsKey(option.key())) continue;
            option.onLoadListeners().forEach(listener -> listener.accept(this.get(option)));
        }
        return this;
    }

    public Config save() {
        this.saveInternal(true);
        return this;
    }

    public Config saveWithUnregisteredData() {
        this.saveInternal(false);
        return this;
    }

    private void saveInternal(boolean onlyRegistered) {
        if (this.file == null) {
            Configured.LOGGER.severe("No file specified for config!");
            return;
        }
        if (this.options.contains(VERSION_OPTION)) {
            this.set(VERSION_OPTION, this.version);
        }
        List<Map.Entry<ConfigOption<?>, Object>> dataToSave = this.getDataToSave(onlyRegistered);
        try {
            File parentFile = this.file.getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            if (!this.file.exists()) {
                Configured.LOGGER.info("Config file '" + this.file.getPath() + "' doesn't exist, creating it");
                this.file.createNewFile();
            }
            this.format.write(this, dataToSave);
        }
        catch (Exception e) {
            Configured.LOGGER.log(Level.SEVERE, "Failed to save config file: " + this.file.getAbsolutePath(), e);
        }
    }

    private List<Map.Entry<ConfigOption<?>, Object>> getDataToSave(boolean onlyRegistered) {
        int size = onlyRegistered ? this.options.size() : this.data.size();
        ArrayList dataToSave = new ArrayList(size);
        for (ConfigOption<?> configOption : this.options) {
            Object value = this.data.getOrDefault(configOption.key(), configOption.defaultValue());
            if (configOption.isHidden() && Objects.equals(value, configOption.defaultValue())) continue;
            dataToSave.add(Map.entry(configOption, value));
        }
        if (onlyRegistered) {
            return dataToSave;
        }
        for (Map.Entry entry : this.data.entrySet()) {
            ConfigOption option = ConfigOption.ofObject((String)entry.getKey(), entry.getValue());
            if (this.options.contains(option)) continue;
            dataToSave.add(Map.entry(option, entry.getValue()));
        }
        return dataToSave;
    }

    @Nullable
    public File file() {
        return this.file;
    }

    public Config file(File file) {
        this.file = file;
        return this;
    }

    public boolean exists() {
        return this.file != null && this.file.exists();
    }

    public Config version(int version) {
        this.version = version;
        if (!this.options.contains(VERSION_OPTION)) {
            this.register(VERSION_OPTION);
        }
        return this;
    }

    public Optional<Integer> version() {
        return Optional.ofNullable(this.version);
    }

    public Optional<Integer> currentVersion() {
        return Optional.ofNullable(this.getOrNull(VERSION_OPTION));
    }

    private boolean isVersionMismatch() {
        if (this.version == null) {
            return false;
        }
        int fileVersion = this.get(VERSION_OPTION);
        return fileVersion != this.version;
    }

    public Config separateConfigOptions(boolean separateConfigOptions) {
        this.format.separateConfigOptions(separateConfigOptions);
        return this;
    }

    public Config writeComments(boolean writeComments) {
        this.format.writeComments(writeComments);
        return this;
    }

    @Nullable
    public String header() {
        return this.header;
    }

    public Config header(String header) {
        this.header = header.trim();
        return this;
    }

    @Nullable
    public String footer() {
        return this.footer;
    }

    public Config footer(String footer) {
        this.footer = footer.trim();
        return this;
    }

    public Config oldKeyGenerator(Function<String, String> generator) {
        this.oldKeyGenerator = generator;
        return this;
    }

    @Nullable
    private String generateOldKey(ConfigOption<?> option) {
        if (this.oldKeyGenerator != null) {
            return this.oldKeyGenerator.apply(option.key());
        }
        return null;
    }
}

