/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickauth.shadow.de.clickism.configured.localization;

import de.clickism.clickauth.shadow.de.clickism.configured.Config;
import de.clickism.clickauth.shadow.de.clickism.configured.ConfigOption;
import de.clickism.clickauth.shadow.de.clickism.configured.Configured;
import de.clickism.clickauth.shadow.de.clickism.configured.format.ConfigFormat;
import de.clickism.clickauth.shadow.de.clickism.configured.format.ConfigFormatProvider;
import de.clickism.clickauth.shadow.de.clickism.configured.localization.LocalizationKey;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Localization {
    private final Function<String, File> fileGenerator;
    private final ConfigFormat format;
    private final Set<ConfigOption<?>> options = new LinkedHashSet();
    private String parameterFormat = "{%s}";
    @Nullable
    private String fallbackLanguage;
    @Nullable
    private String language;
    private Config config;
    private Config fallbackConfig;
    @Nullable
    private Integer version;
    @Nullable
    private ResourceProvider resourceProvider;
    private boolean updateWithNewKeys = false;

    public Localization(Function<String, File> fileGenerator, ConfigFormat format) {
        this.format = format;
        this.fileGenerator = fileGenerator;
    }

    public static Localization of(Function<String, String> pathGenerator) {
        ConfigFormat format = ConfigFormatProvider.getFormat(pathGenerator.apply(""), ConfigFormatProvider.getCallerClass());
        return Localization.of(pathGenerator, format);
    }

    public static Localization of(Function<String, String> pathGenerator, ConfigFormat format) {
        return new Localization(pathGenerator.andThen(File::new), format);
    }

    public Localization fallbackLanguage(String language) {
        this.fallbackLanguage = language;
        return this;
    }

    @Nullable
    public String fallbackLanguage() {
        return this.fallbackLanguage;
    }

    public Localization language(String language) {
        this.language = language;
        return this;
    }

    @Nullable
    public String language() {
        return this.language;
    }

    public Localization version(int version) {
        this.version = version;
        return this;
    }

    @Nullable
    public Integer version() {
        return this.version;
    }

    private boolean isVersionMismatch() {
        if (this.version == null) {
            return false;
        }
        if (this.config == null) {
            return false;
        }
        return this.config.currentVersion().map(version -> !version.equals(this.version)).orElse(true);
    }

    public <T extends Enum<T>> Localization registerKeysFor(Class<T> enumClass) {
        for (Enum enumConstant : (Enum[])enumClass.getEnumConstants()) {
            this.registerKey((LocalizationKey)((Object)enumConstant));
        }
        return this;
    }

    public Localization registerKey(LocalizationKey key) {
        this.options.add(ConfigOption.ofObject(key.key(), key.key()));
        return this;
    }

    public Localization updateWithNewKeys(boolean updateWithNewKeys) {
        this.updateWithNewKeys = updateWithNewKeys;
        return this;
    }

    public Localization load() {
        if (this.language == null) {
            if (this.fallbackLanguage == null) {
                Configured.LOGGER.warning("No language or fallback language set for localization!");
                return this;
            }
            Configured.LOGGER.warning("No language code specified for localization, using fallback language...");
            this.language = this.fallbackLanguage;
        }
        this.config = this.createLanguageConfig(this.language);
        this.deployOrGenerateLocalizationFile(this.config, this.language);
        if (this.fallbackLanguage != null && !this.fallbackLanguage.equals(this.language)) {
            this.fallbackConfig = this.createLanguageConfig(this.fallbackLanguage);
            this.deployOrGenerateLocalizationFile(this.fallbackConfig, this.fallbackLanguage);
        }
        return this;
    }

    private void deployOrGenerateLocalizationFile(@NotNull Config config, @NotNull String language) {
        if (!config.exists()) {
            if (this.resourceProvider != null) {
                Configured.LOGGER.info("No localization file found for '" + language + "'. Deploying from resource...");
                this.deployLocalizationFile(config, language);
                return;
            }
            Configured.LOGGER.warning("No localization file found for '" + language + "'. But no resource directory set! Generating an empty localization file instead.");
        }
        if (this.updateWithNewKeys) {
            config.load();
        } else {
            config.loadWithoutUpdating();
        }
        if (this.isVersionMismatch()) {
            if (this.resourceProvider != null) {
                Configured.LOGGER.info("Version mismatch detected. Deploying from resource directory for '" + language + "'...");
                this.deployLocalizationFile(config, language);
            } else {
                Configured.LOGGER.warning("Version mismatch detected, but no resource directory set! Please ensure the localization files are up to date");
            }
        }
    }

    private void deployLocalizationFile(@NotNull Config config, @NotNull String language) {
        if (this.resourceProvider == null) {
            return;
        }
        String path = this.resourceProvider.pathGenerator.apply(language);
        if (this.deploySingleResource(this.resourceProvider.clazz(), path, this.fileGenerator.apply(language).getPath())) {
            config.loadWithoutUpdating();
            if (this.version != null && config.currentVersion().isEmpty()) {
                config.version(this.version);
                config.saveWithUnregisteredData();
            }
        } else {
            config.load();
        }
    }

    private Config createLanguageConfig(String language) {
        Config config = new Config(this.fileGenerator.apply(language), this.format);
        if (this.version != null) {
            config.version(this.version);
        }
        return config.separateConfigOptions(false).registerAll(this.options);
    }

    public String get(LocalizationKey key, Object ... params) {
        String result = this.getLocalizedString(key);
        String[] paramNames = key.parameters();
        for (int i = 0; i < Math.min(params.length, paramNames.length); ++i) {
            Object param = params[i];
            String paramName = paramNames[i];
            String placeholder = String.format(this.parameterFormat, paramName);
            result = result.replace(placeholder, String.valueOf(param));
        }
        return result;
    }

    private String getLocalizedString(LocalizationKey key) {
        if (this.config == null) {
            return this.getFallbackString(key);
        }
        String localizedString = Localization.getStringOrNull(key, this.config);
        if (localizedString != null) {
            return localizedString;
        }
        return this.getFallbackString(key);
    }

    private String getFallbackString(LocalizationKey key) {
        String string;
        if (this.fallbackConfig != null && (string = Localization.getStringOrNull(key, this.fallbackConfig)) != null) {
            return string;
        }
        return key.key();
    }

    @Nullable
    private static String getStringOrNull(LocalizationKey key, Config config) {
        Object value = config.get(ConfigOption.ofObject(key.key(), null));
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            Collection multilineString = (Collection)value;
            return multilineString.stream().map(Object::toString).collect(Collectors.joining("\n"));
        }
        return value.toString();
    }

    public Localization resourceProvider(Class<?> clazz, Function<String, String> pathGenerator) {
        this.resourceProvider = new ResourceProvider(clazz, pathGenerator);
        return this;
    }

    public String parameterFormat() {
        return this.parameterFormat;
    }

    public Localization parameterFormat(String parameterFormat) {
        this.parameterFormat = parameterFormat;
        return this;
    }

    protected boolean deploySingleResource(Class<?> clazz, String resourcePath, String destinationPath) {
        boolean bl;
        block10: {
            Configured.LOGGER.info("Deploying resource '" + resourcePath + "' to '" + destinationPath + "'...");
            InputStream in = clazz.getResourceAsStream(resourcePath);
            try {
                if (in == null) {
                    throw new FileNotFoundException("Resource not found: " + resourcePath + ". Local file will be used instead.");
                }
                File destinationFile = new File(destinationPath);
                File destinationDirectory = destinationFile.getParentFile();
                if (destinationDirectory != null) {
                    Files.createDirectories(destinationDirectory.toPath(), new FileAttribute[0]);
                }
                Files.copy(in, destinationFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                bl = true;
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Configured.LOGGER.severe("Failed to deploy resource: " + e.getMessage());
                    return false;
                }
            }
            in.close();
        }
        return bl;
    }

    private record ResourceProvider(Class<?> clazz, Function<String, String> pathGenerator) {
    }
}

