/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickauth.shadow.de.clickism.configured.localization;

import de.clickism.clickauth.shadow.de.clickism.configured.localization.LocalizationKey;
import de.clickism.clickauth.shadow.de.clickism.configured.localization.Parameters;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ParameterRegistry {
    private static final Set<String> REGISTERED_CLASSES = new HashSet<String>();
    private static final Map<LocalizationKey, String[]> PARAMETERS = new HashMap<LocalizationKey, String[]>();

    private ParameterRegistry() {
    }

    public static String[] getParameters(LocalizationKey key) {
        ParameterRegistry.registerParametersForParentClass(key);
        return PARAMETERS.getOrDefault(key, new String[0]);
    }

    private static void registerParametersForParentClass(LocalizationKey key) {
        if (key == null) {
            return;
        }
        Class<?> clazz = key.getClass();
        if (!clazz.isEnum()) {
            return;
        }
        String className = clazz.getName();
        if (REGISTERED_CLASSES.contains(className)) {
            return;
        }
        REGISTERED_CLASSES.add(className);
        for (Field field : clazz.getDeclaredFields()) {
            ParameterRegistry.registerParametersForField(field);
        }
    }

    private static void registerParametersForField(Field field) {
        Object value;
        field.setAccessible(true);
        try {
            value = field.get(null);
        }
        catch (Exception e) {
            return;
        }
        if (field.isAnnotationPresent(Parameters.class) && value instanceof LocalizationKey) {
            LocalizationKey valueKey = (LocalizationKey)value;
            Parameters params = field.getAnnotation(Parameters.class);
            PARAMETERS.put(valueKey, params.value());
        }
    }
}

