/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickmobs;

import de.clickism.clickmobs.ClickMobsConfig;
import de.clickism.clickmobs.config.ReloadCommand;
import de.clickism.clickmobs.entity.EntitySaver;
import de.clickism.clickmobs.entity.EntitySaverFactory;
import de.clickism.clickmobs.listener.DispenserListener;
import de.clickism.clickmobs.listener.JoinListener;
import de.clickism.clickmobs.listener.VehicleInteractListener;
import de.clickism.clickmobs.message.Message;
import de.clickism.clickmobs.mob.PickupManager;
import de.clickism.clickmobs.predicate.MobList;
import de.clickism.clickmobs.predicate.MobListParser;
import de.clickism.clickmobs.util.UpdateChecker;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.plugin.java.JavaPlugin;

public final class ClickMobs
extends JavaPlugin {
    public static final String PROJECT_ID = "clickmobs";
    public static ClickMobs INSTANCE;
    public static Logger LOGGER;
    @Nullable
    private String newerVersion;

    public void onLoad() {
        INSTANCE = this;
        LOGGER = this.getLogger();
    }

    public void onEnable() {
        MobListParser parser = new MobListParser();
        MobList whitelistedMobs = new MobList();
        MobList blacklistedMobs = new MobList();
        ClickMobsConfig.WHITELISTED_MOBS.onLoad(lines -> {
            whitelistedMobs.clear();
            whitelistedMobs.addAll(parser.parseMobList((List<String>)lines));
        });
        ClickMobsConfig.BLACKLISTED_MOBS.onLoad(lines -> {
            blacklistedMobs.clear();
            blacklistedMobs.addAll(parser.parseMobList((List<String>)lines));
        });
        HashSet<String> blacklistedItemsInHand = new HashSet<String>();
        ClickMobsConfig.BLACKLISTED_ITEMS_IN_HAND.onLoad(lines -> {
            blacklistedItemsInHand.clear();
            blacklistedItemsInHand.addAll((Collection<String>)lines);
        });
        ClickMobsConfig.CONFIG.load();
        EntitySaver entitySaver = EntitySaverFactory.create();
        PickupManager pickupManager = new PickupManager(this, entitySaver, whitelistedMobs, blacklistedMobs, blacklistedItemsInHand);
        new DispenserListener(this, pickupManager);
        new VehicleInteractListener(this, pickupManager);
        PluginCommand command = Bukkit.getPluginCommand((String)PROJECT_ID);
        if (command != null) {
            command.setExecutor((CommandExecutor)new ReloadCommand());
        }
        if (ClickMobsConfig.CONFIG.get(ClickMobsConfig.CHECK_UPDATE).booleanValue()) {
            this.checkUpdates();
            new JoinListener(this, () -> this.newerVersion);
        }
    }

    private void checkUpdates() {
        LOGGER.info("Checking for updates...");
        new UpdateChecker(PROJECT_ID, "spigot", null).checkVersion(version -> {
            if (this.getDescription().getVersion().equals(version)) {
                return;
            }
            this.newerVersion = version;
            LOGGER.info("New version available: " + version);
            Bukkit.getOnlinePlayers().forEach(player -> {
                if (!player.isOp()) {
                    return;
                }
                Message.UPDATE.send((CommandSender)player, this.newerVersion);
            });
        });
    }
}

