/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickmobs.entity;

import de.clickism.clickmobs.entity.EntitySaver;
import de.clickism.clickmobs.entity.NMSUtils;
import java.lang.reflect.Method;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTTagCompound;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class NMSSaver
implements EntitySaver {
    private static final Class<?> CRAFT_ENTITY_CLASS;
    private static final Method GET_HANDLE_METHOD;

    private static net.minecraft.world.entity.Entity getNmsEntity(Entity entity) throws Exception {
        Object nmsEntity = CRAFT_ENTITY_CLASS.cast(entity);
        return (net.minecraft.world.entity.Entity)GET_HANDLE_METHOD.invoke(nmsEntity, new Object[0]);
    }

    @Override
    public String writeToString(Entity entity) throws IllegalArgumentException {
        try {
            net.minecraft.world.entity.Entity nmsEntity = NMSSaver.getNmsEntity(entity);
            NBTTagCompound nbt = new NBTTagCompound();
            nmsEntity.e(nbt);
            return nbt.toString();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to write NBT: " + String.valueOf(entity));
        }
    }

    @Override
    public Entity readAndSpawnAt(String string, EntityType type, Location location) throws IllegalArgumentException {
        try {
            World world = location.getWorld();
            if (world == null) {
                throw new IllegalArgumentException("World cannot be null");
            }
            Entity entity = world.spawnEntity(location, type);
            NBTTagCompound nbt = MojangsonParser.a((String)string);
            nbt.a("UUID", entity.getUniqueId());
            net.minecraft.world.entity.Entity nmsEntity = NMSSaver.getNmsEntity(entity);
            nmsEntity.g(nbt);
            entity.teleport(location);
            return entity;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to read NBT: " + string);
        }
    }

    static {
        try {
            CRAFT_ENTITY_CLASS = Class.forName(NMSUtils.cbClass("entity.CraftEntity"));
            GET_HANDLE_METHOD = CRAFT_ENTITY_CLASS.getMethod("getHandle", new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException("Failed to initialize NMSSaver", e);
        }
    }
}

