/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickmobs.entity;

import de.clickism.clickmobs.entity.EntitySaver;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class SnapshotSaver
implements EntitySaver {
    private static final Class<?> ENTITY_SNAPSHOT_CLASS;
    private static final Class<?> ENTITY_FACTORY_CLASS;
    private static final Method CREATE_SNAPSHOT_METHOD;
    private static final Method GET_AS_STRING_METHOD;
    private static final Method GET_FACTORY_METHOD;
    private static final Method CREATE_ENTITY_SNAPSHOT_METHOD;
    private static final Method CREATE_ENTITY_METHOD;
    private static final Pattern LEVEL_FIX_PATTERN;
    private static final Matcher MATCHER;

    private static String appendEntityTypeIfAbsent(String string, EntityType type) {
        String typeData = "id:\"" + String.valueOf(type.getKey()) + "\"";
        if (!string.contains(typeData)) {
            StringBuilder builder = new StringBuilder(string);
            builder.setCharAt(builder.length() - 1, ',');
            builder.append(typeData);
            builder.append("}");
            return builder.toString();
        }
        return string;
    }

    private static String getNBTFixedString(String string) {
        MATCHER.reset(string);
        StringBuilder result = new StringBuilder();
        while (MATCHER.find()) {
            MATCHER.appendReplacement(result, Matcher.quoteReplacement(MATCHER.group(1)));
        }
        MATCHER.appendTail(result);
        return result.toString();
    }

    @Override
    public String writeToString(Entity entity) throws IllegalArgumentException {
        try {
            Object snapshot = CREATE_SNAPSHOT_METHOD.invoke((Object)entity, new Object[0]);
            if (snapshot == null) {
                throw new IllegalArgumentException("Failed to create snapshot for entity: " + String.valueOf(entity));
            }
            return (String)GET_AS_STRING_METHOD.invoke(snapshot, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to create snapshot: " + String.valueOf(entity), e);
        }
    }

    @Override
    public Entity readAndSpawnAt(String string, EntityType type, Location location) throws IllegalArgumentException {
        string = SnapshotSaver.getNBTFixedString(string);
        string = SnapshotSaver.appendEntityTypeIfAbsent(string, type);
        try {
            Object factory = GET_FACTORY_METHOD.invoke(null, new Object[0]);
            Object snapshot = CREATE_ENTITY_SNAPSHOT_METHOD.invoke(factory, string);
            return (Entity)CREATE_ENTITY_METHOD.invoke(snapshot, location);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to read NBT: " + string, e);
        }
    }

    static {
        LEVEL_FIX_PATTERN = Pattern.compile("levels:\\{(.*?)}");
        MATCHER = LEVEL_FIX_PATTERN.matcher("");
        try {
            ENTITY_SNAPSHOT_CLASS = Class.forName("org.bukkit.entity.EntitySnapshot");
            GET_AS_STRING_METHOD = ENTITY_SNAPSHOT_CLASS.getMethod("getAsString", new Class[0]);
            CREATE_SNAPSHOT_METHOD = Entity.class.getMethod("createSnapshot", new Class[0]);
            GET_FACTORY_METHOD = Bukkit.class.getMethod("getEntityFactory", new Class[0]);
            ENTITY_FACTORY_CLASS = Class.forName("org.bukkit.entity.EntityFactory");
            CREATE_ENTITY_SNAPSHOT_METHOD = ENTITY_FACTORY_CLASS.getMethod("createEntitySnapshot", String.class);
            CREATE_ENTITY_METHOD = ENTITY_SNAPSHOT_CLASS.getMethod("createEntity", Location.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException("Failed to initialize SnapshotSaver", e);
        }
    }
}

