/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickmobs.listener;

import de.clickism.clickmobs.ClickMobs;
import de.clickism.clickmobs.listener.AutoRegistered;
import de.clickism.clickmobs.message.Message;
import de.clickism.clickmobs.mob.PickupManager;
import java.util.List;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Boat;
import org.bukkit.entity.ChestBoat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.entity.minecart.RideableMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class VehicleInteractListener
implements Listener {
    private final PickupManager pickupManager;

    @AutoRegistered
    public VehicleInteractListener(JavaPlugin plugin, PickupManager pickupManager) {
        this.pickupManager = pickupManager;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(ignoreCancelled=true)
    private void onVehicleInteract(PlayerInteractEntityEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Entity entity = event.getRightClicked();
        if (!(entity instanceof Minecart) && !(entity instanceof Boat)) {
            return;
        }
        Player player = event.getPlayer();
        if (!player.isSneaking()) {
            return;
        }
        PlayerInventory inventory = player.getInventory();
        ItemStack item = inventory.getItemInMainHand();
        if (!this.pickupManager.isMob(item)) {
            return;
        }
        event.setCancelled(true);
        if (!this.hasSpace(entity)) {
            return;
        }
        try {
            LivingEntity villager = this.pickupManager.spawnFromItemStack(item, entity.getLocation());
            item.setAmount(item.getAmount() - 1);
            inventory.setItemInMainHand(item);
            World world = player.getWorld();
            if (entity instanceof Minecart) {
                world.playSound((Entity)player, Sound.BLOCK_METAL_BREAK, 1.0f, 0.5f);
            } else {
                world.playSound((Entity)player, Sound.BLOCK_WOOD_BREAK, 1.0f, 0.5f);
            }
            entity.addPassenger((Entity)villager);
        }
        catch (IllegalArgumentException exception) {
            Message.READ_ERROR.send((CommandSender)player, new Object[0]);
            ClickMobs.LOGGER.severe("Failed to read mob data: " + exception.getMessage());
        }
    }

    private boolean hasSpace(Entity entity) {
        List passengers = entity.getPassengers();
        if (entity instanceof RideableMinecart || entity instanceof ChestBoat) {
            return passengers.isEmpty();
        }
        if (entity instanceof Boat) {
            return passengers.size() < 2;
        }
        return false;
    }
}

