/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickmobs.predicate;

import de.clickism.clickmobs.predicate.CustomDataMobPredicateType;
import de.clickism.clickmobs.util.Utils;
import java.util.List;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Tameable;

public interface MobPredicateType<T> {
    public static final MobPredicateType<?> ALL = (entity, args) -> true;
    public static final MobPredicateType<?> HOSTILE = (entity, args) -> entity instanceof Monster;
    public static final MobPredicateType<?> BABY = (entity, args) -> {
        Ageable ageable;
        return entity instanceof Ageable && !(ageable = (Ageable)entity).isAdult();
    };
    public static final MobPredicateType<?> TAMED = (entity, args) -> {
        Tameable tameable;
        return entity instanceof Tameable && (tameable = (Tameable)entity).isTamed();
    };
    public static final MobPredicateType<String> NAMETAGGED = (entity, args) -> {
        String customName = entity.getCustomName();
        if (args.isEmpty()) {
            return customName != null;
        }
        return customName != null && customName.equals(args.get(0));
    };
    public static final MobPredicateType<?> SILENT = (entity, args) -> entity.isSilent();
    public static final MobPredicateType<String> MOB = (entity, args) -> args.stream().anyMatch(string -> string.equalsIgnoreCase(Utils.getKeyOfEntity((Entity)entity)));
    public static final MobPredicateType<?> LEASHED = (entity, args) -> entity.isLeashed();
    public static final MobPredicateType<?> CUSTOM_DATA = new CustomDataMobPredicateType();

    public boolean test(LivingEntity var1, List<T> var2);

    default public List<T> parseArgs(List<String> args) {
        return args.stream().map(this::parseArg).toList();
    }

    default public T parseArg(String arg) {
        return (T)arg;
    }
}

