/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickmobs.util;

import de.clickism.clickmobs.util.Utils;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class Parameterizer {
    protected static final String UPPERCASE_SELECTOR = "^";
    protected static final String FORMAT = "{%s}";
    protected final Map<String, Object> params = new HashMap<String, Object>();
    private final String string;
    protected boolean colorize = true;

    protected Parameterizer(String string) {
        this.string = string;
    }

    public static Parameterizer empty() {
        return new Parameterizer("");
    }

    public static Parameterizer of(String string) {
        return new Parameterizer(string);
    }

    public Parameterizer put(String key, @NotNull Object value) {
        this.params.put(key, value);
        return this;
    }

    public Parameterizer putAll(Parameterizer parameterizer) {
        this.params.putAll(parameterizer.params);
        return this;
    }

    public Parameterizer disableColorizeParameters() {
        this.colorize = false;
        return this;
    }

    public String replace(String string) {
        String result = Utils.colorize(string);
        for (Map.Entry<String, Object> entry : this.params.entrySet()) {
            String value = entry.getValue().toString();
            String uppercasedKey = String.format("^{%s}", entry.getKey());
            result = result.replace(uppercasedKey, Utils.capitalize(value));
            String key = String.format(FORMAT, entry.getKey());
            result = result.replace(key, value);
        }
        if (this.colorize) {
            result = Utils.colorize(result);
        }
        return result;
    }

    public String toString() {
        return this.replace(this.string);
    }
}

