/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickmobs.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class UpdateChecker {
    private static final String API_URL = "https://api.modrinth.com/v2/project/{id}/version";
    private final String projectId;
    private final String loader;
    @Nullable
    private final String minecraftVersion;

    public UpdateChecker(String projectId, String loader, @Nullable String minecraftVersion) {
        this.projectId = projectId;
        this.loader = loader;
        this.minecraftVersion = minecraftVersion;
    }

    public static String getRawVersion(String version) {
        if (version.isEmpty()) {
            return version;
        }
        version = version.replaceAll("^\\D+", "");
        String[] split = version.split("\\+");
        return split[0];
    }

    public void checkVersion(Consumer<String> consumer) {
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(API_URL.replace("{id}", this.projectId))).GET().build();
            client.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenAcceptAsync(response -> {
                if (response.statusCode() != 200) {
                    return;
                }
                JsonArray versionsArray = JsonParser.parseString((String)((String)response.body())).getAsJsonArray();
                String latestVersion = this.getLatestVersion(versionsArray);
                if (latestVersion == null) {
                    return;
                }
                consumer.accept(latestVersion);
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    protected String getLatestVersion(JsonArray versions) {
        return versions.asList().stream().map(JsonElement::getAsJsonObject).filter(this::isVersionCompatible).map(version -> version.get("version_number").getAsString()).map(UpdateChecker::getRawVersion).max(String::compareTo).orElse(null);
    }

    protected boolean isVersionCompatible(JsonObject version) {
        JsonArray versions = version.get("game_versions").getAsJsonArray();
        JsonArray loaders = version.get("loaders").getAsJsonArray();
        return (this.minecraftVersion == null || versions.contains((JsonElement)new JsonPrimitive(this.minecraftVersion))) && loaders.contains((JsonElement)new JsonPrimitive(this.loader));
    }
}

