/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickmobs;

import de.clickism.clickmobs.message.Message;
import de.clickism.clickmobs.shadow.de.clickism.configured.Config;
import de.clickism.clickmobs.shadow.de.clickism.configured.ConfigOption;
import java.util.List;
import java.util.Map;

public class ClickMobsConfig {
    public static final Config CONFIG = Config.of("plugins/ClickMobs/config.yml").version(8).header("---------------------------------------------------------\nClickMobs Config\nNOTE: RELOAD/RESTART SERVER FOR CHANGES TO TAKE EFFECT\n---------------------------------------------------------\n");
    public static final ConfigOption<String> LANGUAGE = CONFIG.optionOf("language", "en_US").description("Language of the plugin.\nCurrently supported languages: en_US, de_DE\n").onLoad(lang -> Message.LOCALIZATION.language((String)lang).load());
    public static final ConfigOption<Boolean> CHECK_UPDATE = CONFIG.optionOf("check_update", true).description("Whether to check for updates on server startup. Strongly Recommended.\n").appendDefaultValue();
    public static final ConfigOption<Boolean> PER_MOB_PERMISSIONS = CONFIG.optionOf("per_mob_permissions", false).description("Whether to have specific permissions for each mob.\nFor example, players won't be able to pick up a creeper unless they have\nBOTH \"clickmobs.pickup\" and \"clickmobs.pickup.creeper\" permissions.\n- Whitelisted mobs will still be able to be picked up without a mob-specific permission.\n- Blacklisted mobs will not be able to be picked up even with a mob-specific permission.\n").appendDefaultValue();
    public static final ConfigOption<Boolean> ENABLE_DISPENSERS = CONFIG.optionOf("enable_dispensers", true).description("Whether dispensers can dispense picked up mobs.\n").appendDefaultValue();
    public static final ConfigOption<List<String>> WHITELISTED_MOBS = CONFIG.optionOf("whitelisted_mobs", List.of("cow", "pig", "sheep"), String.class).header("---------------------------------------------------------\nIn the following section you can whitelist/blacklist mobs.\n---------------------------------------------------------\nTo whitelist/blacklist a vanilla mob, add its entity name.\n    i.E: \"creeper\" or \"ender_dragon\"\n---------------------------------------------------------\nYou can also use tags (predicates) to whitelist/blacklist mobs with certain properties.\nAvailable tags are:\n    ?all, ?hostile, ?baby, ?tamed, ?nametagged, ?silent, ?mob\n\nYou can (optionally) pass arguments to certain tags:\n    - ?nametagged(Dinnerbone)\nYou can combine multiple tags:\n    - ?tamed ?nametagged\nYou can negate tags using \"not\":\n    - not ?hostile\nYou can use the ?mob tag alongside other tags to use tags on specific mobs:\n    - ?mob(creeper, zombie) ?nametagged(Friendly!)\nYou can use the ?customdata tag to target mobs added by other plugins or mobs with\ncustom data. Please read the wiki for more information on this tag.\n\nCheck the wiki for more documentation on tags:\nhttps://clickism.de/docs/clickmobs/tags\n---------------------------------------------------------\n").description("Mobs that are allowed to be picked up.\nThe whitelist takes precedence over the blacklist.\n(Blacklisted mobs included in the whitelist will still be allowed)\n").appendDefaultValue();
    public static final ConfigOption<List<String>> BLACKLISTED_MOBS = CONFIG.optionOf("blacklisted_mobs", List.of("?hostile", "wither", "ender_dragon"), String.class).description("Mobs that are not allowed to be picked up.\n").appendDefaultValue();
    public static final ConfigOption<List<String>> BLACKLISTED_ITEMS_IN_HAND = CONFIG.optionOf("blacklisted_items_in_hand", List.of("lead", "saddle"), String.class).description("Items that prevent picking up mobs when held in hand.\nUse the item names (material names) of the items.\n\nHarnesses are always blocked for Happy Ghast compatibility\nand do not need to be added here.\n\nUse the tag \"?all\" to block all items. This will make it so players\ncan only pick up mobs with an empty hand.\n").appendDefaultValue();
    public static final ConfigOption<Map<String, Integer>> CUSTOM_MODEL_DATA = CONFIG.optionOf("custom_model_data", Map.of("creeper", 0, "skeleton", 0), String.class, Integer.class).description("Set a custom model data for the picked up mobs.\nThis is useful for resource packs that want to change the model/texture of picked up mobs.\nValue 0 will not change the model.\n");
}

