/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickmobs.config;

import de.clickism.clickmobs.message.Message;
import org.bukkit.command.CommandSender;

public enum Permission {
    PICKUP,
    PLACE,
    RELOAD;

    private static final String PLUGIN_PREFIX = "clickmobs";
    private final String permission;

    private Permission() {
        String name = this.name().replace('_', '-').toLowerCase();
        this.permission = "clickmobs." + name;
    }

    public static boolean hasPickupPermissionFor(CommandSender sender, String mobName) {
        String mobKey = mobName.toLowerCase();
        return sender.hasPermission("clickmobs.pickup." + mobKey);
    }

    public boolean has(CommandSender player) {
        return player.hasPermission(this.permission);
    }

    public boolean lacks(CommandSender player) {
        return !this.has(player);
    }

    public boolean lacksAndNotify(CommandSender player) {
        if (this.lacks(player)) {
            Message.NO_PERMISSION.send(player, new Object[0]);
            return true;
        }
        return false;
    }
}

