/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickmobs.listener;

import de.clickism.clickmobs.ClickMobs;
import de.clickism.clickmobs.ClickMobsConfig;
import de.clickism.clickmobs.listener.AutoRegistered;
import de.clickism.clickmobs.mob.PickupManager;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Dispenser;
import org.bukkit.block.data.Directional;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class DispenserListener
implements Listener {
    private final PickupManager pickupManager;

    @AutoRegistered
    public DispenserListener(JavaPlugin plugin, PickupManager pickupManager) {
        this.pickupManager = pickupManager;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    private void onRedstone(BlockRedstoneEvent event) {
        if (!ClickMobsConfig.CONFIG.get(ClickMobsConfig.ENABLE_DISPENSERS).booleanValue()) {
            return;
        }
        Block block = event.getBlock();
        if (event.getOldCurrent() != 0 || event.getNewCurrent() <= 0) {
            return;
        }
        ArrayList<Block> dispensers = new ArrayList<Block>();
        for (BlockFace face : BlockFace.values()) {
            Block relative = block.getRelative(face);
            if (relative.getType() != Material.DISPENSER) continue;
            dispensers.add(relative);
        }
        if (dispensers.isEmpty()) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)ClickMobs.INSTANCE, () -> {
            for (Block dispenser : dispensers) {
                if (!dispenser.isBlockIndirectlyPowered()) {
                    return;
                }
                if (dispenser.getType() != Material.DISPENSER) {
                    return;
                }
                this.dispenseMob(dispenser);
            }
        }, 1L);
    }

    private void dispenseMob(Block block) {
        Dispenser dispenser = (Dispenser)block.getState();
        Inventory inventory = dispenser.getSnapshotInventory();
        ArrayList<ItemStack> mobs = new ArrayList<ItemStack>();
        for (ItemStack item : inventory) {
            if (item == null || !this.pickupManager.isMob(item)) continue;
            mobs.add(item);
        }
        if (mobs.isEmpty()) {
            return;
        }
        ItemStack item = (ItemStack)mobs.get((int)(Math.random() * (double)mobs.size()));
        try {
            BlockFace facing = ((Directional)dispenser.getBlockData()).getFacing();
            Location location = block.getRelative(facing).getLocation().add(0.5, 0.0, 0.5);
            this.pickupManager.spawnFromItemStack(item, location);
            item.setAmount(item.getAmount() - 1);
            if (item.getAmount() <= 0) {
                item.setType(Material.AIR);
            }
            dispenser.update(true, false);
        }
        catch (IllegalArgumentException exception) {
            ClickMobs.LOGGER.severe("Failed to spawn mob from NBT data: " + exception.getMessage());
        }
    }

    @EventHandler(ignoreCancelled=true)
    private void onDispense(BlockDispenseEvent event) {
        if (!ClickMobsConfig.CONFIG.get(ClickMobsConfig.ENABLE_DISPENSERS).booleanValue()) {
            return;
        }
        ItemStack item = event.getItem();
        if (!this.pickupManager.isMob(item)) {
            return;
        }
        event.setCancelled(true);
    }
}

