/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickmobs.listener;

import de.clickism.clickmobs.listener.AutoRegistered;
import de.clickism.clickmobs.message.Message;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class JoinListener
implements Listener {
    private final JavaPlugin plugin;
    private final Supplier<String> newerVersionSupplier;
    private final Set<UUID> notifiedPlayers = new HashSet<UUID>();

    @AutoRegistered
    public JoinListener(JavaPlugin plugin, Supplier<String> newerVersionSupplier) {
        this.plugin = plugin;
        this.newerVersionSupplier = newerVersionSupplier;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(ignoreCancelled=true)
    private void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (!player.isOp()) {
            return;
        }
        String newerVersion = this.newerVersionSupplier.get();
        if (newerVersion == null) {
            return;
        }
        if (this.notifiedPlayers.contains(player.getUniqueId())) {
            return;
        }
        this.notifiedPlayers.add(player.getUniqueId());
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> Message.UPDATE.send((CommandSender)player, newerVersion), 10L);
    }
}

