/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickmobs.message;

import de.clickism.clickmobs.ClickMobs;
import de.clickism.clickmobs.message.MessageType;
import de.clickism.clickmobs.shadow.de.clickism.configured.localization.Localization;
import de.clickism.clickmobs.shadow.de.clickism.configured.localization.LocalizationKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;

public enum Message implements LocalizationKey
{
    UPDATE(MessageType.WARN),
    NO_PERMISSION(MessageType.FAIL),
    PICK_UP(MessageType.PICK_UP),
    BLACKLISTED_MOB(MessageType.FAIL),
    WRITE_ERROR(MessageType.FAIL),
    READ_ERROR(MessageType.FAIL),
    BABY_MOB,
    MOB$LORE,
    USAGE(MessageType.FAIL),
    RELOAD_SUCCESS(MessageType.CONFIRM),
    RELOAD_FAIL(MessageType.FAIL);

    public static final Localization LOCALIZATION;
    private static final MessageType MISSING;
    private final MessageType type;

    private Message() {
        this(null);
    }

    private Message(MessageType type) {
        this.type = type;
    }

    public static String localize(String key, Object ... params) {
        return LOCALIZATION.get(LocalizationKey.of(key), params);
    }

    public String localized(Object ... params) {
        return LOCALIZATION.get(this, params);
    }

    public void send(CommandSender sender, Object ... params) {
        this.getTypeOrDefault().sendSilently(sender, this.localized(params));
    }

    public void sendSilently(CommandSender sender, Object ... params) {
        this.getTypeOrDefault().sendSilently(sender, this.localized(params));
    }

    public void sendActionbar(CommandSender sender, Object ... params) {
        this.getTypeOrDefault().sendActionbar(sender, this.localized(params));
    }

    public void sendActionbarSilently(CommandSender sender, Object ... params) {
        this.getTypeOrDefault().sendActionbarSilently(sender, this.localized(params));
    }

    public String toString() {
        return this.localized(new Object[0]);
    }

    public List<String> getLore(Object ... params) {
        String pathToLore = this.name().toLowerCase() + ".lore";
        String text = Message.localize(pathToLore, params);
        return Arrays.stream(text.split("\n")).collect(Collectors.toCollection(ArrayList::new));
    }

    public MessageType getTypeOrDefault() {
        return this.type != null ? this.type : MISSING;
    }

    static {
        LOCALIZATION = Localization.of((String lang) -> "plugins/ClickMobs/lang/" + lang + ".json").resourceProvider(ClickMobs.class, lang -> "/lang/" + lang + ".json").fallbackLanguage("en_US").version(3);
        MISSING = MessageType.silent("&2[?] &c", "&8< &2? &f%s &8>");
    }
}

