/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickmobs.message;

import de.clickism.clickmobs.ClickMobs;
import de.clickism.clickmobs.util.Utils;
import java.util.logging.Level;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public abstract class MessageType {
    public static final MessageType CONFIRM = new MessageType("&a[\u2714] ", "&8< &a%s &8>"){

        @Override
        public void playSound(Player player) {
            player.playSound((Entity)player, Sound.BLOCK_NOTE_BLOCK_CHIME, 1.0f, 1.0f);
            Bukkit.getScheduler().runTaskLater((Plugin)ClickMobs.INSTANCE, task -> player.playSound((Entity)player, Sound.BLOCK_NOTE_BLOCK_CHIME, 1.0f, 2.0f), 2L);
        }
    };
    public static final MessageType FAIL = new MessageType("&c[\u274c] ", "&8< &c%s &8>"){

        @Override
        public void playSound(Player player) {
            player.playSound((Entity)player, Sound.BLOCK_AMETHYST_BLOCK_RESONATE, 1.0f, 0.5f);
        }
    };
    public static final MessageType WARN = new MessageType("&e[\u26a0] ", "&8< &e%s &8>"){

        @Override
        public void playSound(Player player) {
            player.playSound((Entity)player, Sound.BLOCK_AMETHYST_BLOCK_RESONATE, 1.0f, 1.0f);
        }
    };
    public static final MessageType PICK_UP = MessageType.silent("&2[\u2191] &a", "&8< &2\u2191 &a%s &8>");
    private final String prefix;
    private final String titleFormat;
    private final String subtitleFormat;

    public MessageType(String prefix, String titleFormat) {
        this(prefix, titleFormat, titleFormat);
    }

    public MessageType(String prefix, String titleFormat, String subtitleFormat) {
        this.prefix = Utils.colorize(prefix);
        this.titleFormat = Utils.colorize(titleFormat);
        this.subtitleFormat = Utils.colorize(subtitleFormat);
    }

    public static MessageType silent(String prefix, String titleFormat) {
        return MessageType.silent(prefix, titleFormat, titleFormat);
    }

    public static MessageType silent(String prefix, String titleFormat, String subtitleFormat) {
        return new MessageType(prefix, titleFormat, subtitleFormat){

            @Override
            public void playSound(Player player) {
            }
        };
    }

    public abstract void playSound(Player var1);

    public void send(CommandSender sender, String message) {
        this.send(sender, message, SendType.CHAT, false);
    }

    public void sendSilently(CommandSender sender, String message) {
        this.send(sender, message, SendType.CHAT, true);
    }

    public void sendActionbar(CommandSender sender, String message) {
        this.send(sender, message, SendType.ACTION_BAR, false);
    }

    public void sendActionbarSilently(CommandSender sender, String message) {
        this.send(sender, message, SendType.ACTION_BAR, true);
    }

    protected void send(CommandSender sender, String message, SendType sendType, boolean silent) {
        switch (sendType.ordinal()) {
            case 0: {
                sender.sendMessage(Utils.colorize(this.prefix + message));
                break;
            }
            case 1: {
                if (!(sender instanceof Player)) break;
                Player player = (Player)sender;
                String formatted = String.format(this.titleFormat, Utils.colorize(message));
                player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)formatted));
            }
        }
        if (!silent && sender instanceof Player) {
            this.playSound((Player)sender);
        }
    }

    public void sendTitle(Player player, String title, String subtitle) {
        this.sendTitle(player, title, subtitle, 5, 60, 10, false);
    }

    public void sendTitle(Player player, String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        this.sendTitle(player, title, subtitle, fadeIn, stay, fadeOut, false);
    }

    public void sendTitleInstant(Player player, String title, String subtitle, int stay) {
        this.sendTitle(player, title, subtitle, 0, stay, 10, false);
    }

    public void sendTitleSilently(Player player, String title, String subtitle) {
        this.sendTitle(player, title, subtitle, 5, 60, 10, true);
    }

    public void sendTitleSilently(Player player, String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        this.sendTitle(player, title, subtitle, fadeIn, stay, fadeOut, true);
    }

    public void sendTitleInstantSilently(Player player, String title, String subtitle, int stay) {
        this.sendTitle(player, title, subtitle, 0, stay, 10, true);
    }

    protected void sendTitle(Player player, String title, String subtitle, int fadeIn, int stay, int fadeOut, boolean silent) {
        String titleMessage = title.isEmpty() ? "" : String.format(this.titleFormat, Utils.colorize(title));
        String subtitleMessage = subtitle.isEmpty() ? "" : String.format(this.subtitleFormat, Utils.colorize(subtitle));
        player.sendTitle(titleMessage, subtitleMessage, fadeIn, stay, fadeOut);
        if (!silent) {
            this.playSound(player);
        }
    }

    public void sendAll(String message) {
        Bukkit.getOnlinePlayers().forEach(player -> this.send((CommandSender)player, message));
        this.log(message);
    }

    public void sendAllSilently(String message) {
        Bukkit.getOnlinePlayers().forEach(player -> this.sendSilently((CommandSender)player, message));
        this.log(message);
    }

    public void sendAllActionbar(String message) {
        Bukkit.getOnlinePlayers().forEach(player -> this.sendActionbar((CommandSender)player, message));
        this.logActionbar(message);
    }

    public void sendAllActionbarSilently(String message) {
        Bukkit.getOnlinePlayers().forEach(player -> this.sendActionbarSilently((CommandSender)player, message));
        this.logActionbar(message);
    }

    public void sendAllTitle(String title, String subtitle) {
        Bukkit.getOnlinePlayers().forEach(player -> this.sendTitle((Player)player, title, subtitle));
        this.logTitle(title, subtitle);
    }

    public void sendAllTitleSilently(String title, String subtitle) {
        Bukkit.getOnlinePlayers().forEach(player -> this.sendTitleSilently((Player)player, title, subtitle));
        this.logTitle(title, subtitle);
    }

    public void sendAllTitleInstant(String title, String subtitle, int stay) {
        Bukkit.getOnlinePlayers().forEach(player -> this.sendTitleInstant((Player)player, title, subtitle, stay));
        this.logTitle(title, subtitle);
    }

    public void sendAllTitleInstantSilently(String title, String subtitle, int stay) {
        Bukkit.getOnlinePlayers().forEach(player -> this.sendTitleInstantSilently((Player)player, title, subtitle, stay));
        this.logTitle(title, subtitle);
    }

    public void sendAllTitle(String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        Bukkit.getOnlinePlayers().forEach(player -> this.sendTitle((Player)player, title, subtitle, fadeIn, stay, fadeOut));
        this.logTitle(title, subtitle);
    }

    public void sendAllTitleSilently(String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        Bukkit.getOnlinePlayers().forEach(player -> this.sendTitleSilently((Player)player, title, subtitle, fadeIn, stay, fadeOut));
        this.logTitle(title, subtitle);
    }

    private void logTitle(String title, String subtitle) {
        if (title.isEmpty()) {
            this.log("Subtitle: " + subtitle);
            return;
        }
        if (subtitle.isEmpty()) {
            this.log("Title: " + title);
            return;
        }
        this.log("Title: " + title + " Subtitle: " + subtitle);
    }

    private void logActionbar(String message) {
        this.log("Actionbar: " + message);
    }

    private void log(String message) {
        String colorized = Utils.colorize(this.prefix + message);
        Bukkit.getLogger().log(Level.INFO, ChatColor.stripColor((String)colorized));
    }

    protected static enum SendType {
        CHAT,
        ACTION_BAR;

    }
}

