/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickmobs.mob;

import de.clickism.clickmobs.ClickMobs;
import de.clickism.clickmobs.ClickMobsConfig;
import de.clickism.clickmobs.config.Permission;
import de.clickism.clickmobs.entity.EntitySaver;
import de.clickism.clickmobs.message.Message;
import de.clickism.clickmobs.mob.MobTextures;
import de.clickism.clickmobs.predicate.MobList;
import de.clickism.clickmobs.util.Utils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PickupManager
implements Listener {
    public static final NamespacedKey ENTITY_KEY = new NamespacedKey((Plugin)ClickMobs.INSTANCE, "entity");
    public static final NamespacedKey TYPE_KEY = new NamespacedKey((Plugin)ClickMobs.INSTANCE, "type");
    public static final NamespacedKey NBT_KEY = new NamespacedKey((Plugin)ClickMobs.INSTANCE, "nbt");
    private static final String ALL_TAG = "?all";
    private final EntitySaver entitySaver;
    private final MobList whitelistedMobs;
    private final MobList blacklistedMobs;
    private final Set<String> blacklistedMaterialsInHand;

    public PickupManager(JavaPlugin plugin, EntitySaver entitySaver, MobList whitelistedMobs, MobList blacklistedMobs, Set<String> blacklistedMaterialsInHand) {
        this.entitySaver = entitySaver;
        this.whitelistedMobs = whitelistedMobs;
        this.blacklistedMobs = blacklistedMobs;
        this.blacklistedMaterialsInHand = blacklistedMaterialsInHand;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    private boolean isBlacklistedItemInHand(Material material) {
        if (this.blacklistedMaterialsInHand.contains(ALL_TAG) && material != Material.AIR) {
            return true;
        }
        if (material.toString().toLowerCase().matches(".*_harness$")) {
            return true;
        }
        return this.blacklistedMaterialsInHand.contains(material.toString().toLowerCase());
    }

    private static String formatEntity(Entity entity) {
        Object name = entity.getType().name().toLowerCase().replace("_", " ");
        if ("de_DE".equals(Message.LOCALIZATION.language())) {
            name = ((String)name).substring(0, 1).toUpperCase() + ((String)name).substring(1);
        }
        return name;
    }

    private static String getName(LivingEntity entity) {
        Ageable ageable;
        if (entity.getCustomName() != null) {
            return "\"" + entity.getCustomName() + "\"";
        }
        String entityName = PickupManager.formatEntity((Entity)entity);
        String name = Utils.capitalize(entityName);
        if (entity instanceof Ageable && !(ageable = (Ageable)entity).isAdult()) {
            return Message.BABY_MOB.localized(name);
        }
        return name;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    private void onInteract(PlayerInteractEntityEvent event) {
        ItemStack item;
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Entity entity = event.getRightClicked();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        if (entity2 instanceof HumanEntity) {
            return;
        }
        Player player = event.getPlayer();
        if (player.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        if (!player.isSneaking()) {
            return;
        }
        ItemStack held = player.getInventory().getItemInMainHand();
        if (this.isBlacklistedItemInHand(held.getType())) {
            return;
        }
        if (!this.canPickUp(player, entity2)) {
            Message.BLACKLISTED_MOB.sendActionbar((CommandSender)player, new Object[0]);
            return;
        }
        if (Permission.PICKUP.lacksAndNotify((CommandSender)player)) {
            return;
        }
        event.setCancelled(true);
        try {
            item = this.toItemStack(entity2);
        }
        catch (IllegalArgumentException exception) {
            Message.WRITE_ERROR.send((CommandSender)player, new Object[0]);
            ClickMobs.LOGGER.severe("Failed to write mob data: " + exception.getMessage());
            return;
        }
        Utils.setHandOrGive(player, item);
        Message.PICK_UP.sendActionbarSilently((CommandSender)player, PickupManager.formatEntity((Entity)entity2));
        this.sendPickupEffect(entity2);
    }

    public void sendPickupEffect(LivingEntity entity) {
        Location location = entity.getLocation().add(0.0, 0.25, 0.0);
        World world = entity.getWorld();
        world.spawnParticle(Particle.SWEEP_ATTACK, location, 1);
        world.playSound(location, Sound.ENTITY_PLAYER_ATTACK_SWEEP, 1.0f, 0.5f);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    private void onPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        PlayerInventory inventory = player.getInventory();
        ItemResult itemResult = this.getHeldMobItem(inventory);
        if (itemResult == null) {
            return;
        }
        event.setCancelled(true);
        if (Permission.PLACE.lacksAndNotify((CommandSender)player)) {
            return;
        }
        Block block = event.getBlockPlaced();
        Location location = block.getLocation().add(0.5, 0.0, 0.5);
        float yaw = player.getLocation().getYaw();
        location.setYaw((yaw + 360.0f) % 360.0f - 180.0f);
        try {
            ItemStack item = itemResult.item();
            this.spawnFromItemStack(item, location);
            itemResult.decrementAmount(inventory);
            World world = player.getWorld();
            world.playSound(location, Sound.ENTITY_PLAYER_ATTACK_WEAK, 1.0f, 0.5f);
            Block blockBelow = block.getRelative(BlockFace.DOWN);
            world.spawnParticle(Particle.BLOCK_CRACK, location, 30, (Object)blockBelow.getBlockData());
        }
        catch (IllegalArgumentException exception) {
            Message.READ_ERROR.send((CommandSender)player, new Object[0]);
            ClickMobs.LOGGER.severe("Failed to read mob data: " + exception.getMessage());
        }
    }

    private ItemResult getHeldMobItem(PlayerInventory inventory) {
        ItemStack item = inventory.getItemInMainHand();
        if (this.isMob(item)) {
            return new ItemResult(item, EquipmentSlot.HAND);
        }
        item = inventory.getItemInOffHand();
        if (this.isMob(item)) {
            return new ItemResult(item, EquipmentSlot.OFF_HAND);
        }
        return null;
    }

    public boolean isMob(ItemStack item) {
        if (item.getType() != Material.PLAYER_HEAD) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        PersistentDataContainer data = meta.getPersistentDataContainer();
        return data.has(ENTITY_KEY, PersistentDataType.BOOLEAN);
    }

    public ItemStack toItemStack(LivingEntity entity) {
        entity = this.getRootEntity(entity);
        Set<LivingEntity> passengers = this.getAllPassengers(entity);
        ItemStack item = this.createItem(entity, passengers);
        this.writeData(entity, item);
        entity.remove();
        passengers.forEach(Entity::remove);
        return item;
    }

    private Set<LivingEntity> getAllPassengers(LivingEntity entity) {
        HashSet<LivingEntity> passengers = new HashSet<LivingEntity>();
        entity.getPassengers().forEach(passenger -> {
            if (!(passenger instanceof LivingEntity)) {
                return;
            }
            LivingEntity livingEntity = (LivingEntity)passenger;
            if (passenger instanceof Player) {
                passenger.leaveVehicle();
                return;
            }
            passengers.add(livingEntity);
            passengers.addAll(this.getAllPassengers(livingEntity));
        });
        return passengers;
    }

    private LivingEntity getRootEntity(LivingEntity entity) {
        Entity entity2 = entity.getVehicle();
        if (entity2 instanceof LivingEntity) {
            LivingEntity vehicle = (LivingEntity)entity2;
            return this.getRootEntity(vehicle);
        }
        return entity;
    }

    private void writeData(LivingEntity entity, ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return;
        }
        PersistentDataContainer data = meta.getPersistentDataContainer();
        data.set(ENTITY_KEY, PersistentDataType.BOOLEAN, (Object)true);
        data.set(TYPE_KEY, PersistentDataType.STRING, (Object)entity.getType().name());
        String nbt = this.entitySaver.writeToString((Entity)entity);
        data.set(NBT_KEY, PersistentDataType.STRING, (Object)nbt);
        item.setItemMeta(meta);
    }

    public LivingEntity spawnFromItemStack(ItemStack item, Location location) {
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            throw new IllegalArgumentException("ItemMeta is null");
        }
        PersistentDataContainer data = meta.getPersistentDataContainer();
        if (!data.has(ENTITY_KEY, PersistentDataType.BOOLEAN)) {
            throw new IllegalArgumentException("Item is not a mob");
        }
        if (!data.has(TYPE_KEY, PersistentDataType.STRING)) {
            throw new IllegalArgumentException("Entity type is missing");
        }
        EntityType type = EntityType.valueOf((String)((String)data.get(TYPE_KEY, PersistentDataType.STRING)));
        World world = location.getWorld();
        if (world == null) {
            throw new IllegalArgumentException("World is null");
        }
        String nbt = (String)data.get(NBT_KEY, PersistentDataType.STRING);
        LivingEntity entity = (LivingEntity)this.entitySaver.readAndSpawnAt(nbt, type, location);
        entity.teleport(location);
        return entity;
    }

    private ItemStack createItem(LivingEntity entity, Set<LivingEntity> passengers) {
        ItemStack item;
        ItemMeta meta;
        String entityName = PickupManager.formatEntity((Entity)entity);
        Object name = PickupManager.getName(entity);
        if (!passengers.isEmpty()) {
            name = (String)name + " \u00a77(+ " + passengers.stream().map(PickupManager::getName).collect(Collectors.joining(" + ")) + ")";
        }
        if ((meta = (item = new ItemStack(Material.PLAYER_HEAD)).getItemMeta()) == null) {
            throw new IllegalArgumentException("ItemMeta is null");
        }
        meta.setDisplayName(String.valueOf(ChatColor.YELLOW) + (String)name);
        meta.setLore(Arrays.stream(Message.MOB$LORE.localized(entityName).split("\n")).toList());
        int modelDataOverride = ClickMobsConfig.CONFIG.get(ClickMobsConfig.CUSTOM_MODEL_DATA).getOrDefault(Utils.getKeyOfEntity((Entity)entity), 0);
        if (modelDataOverride != 0) {
            meta.setCustomModelData(Integer.valueOf(modelDataOverride));
        }
        item.setItemMeta(meta);
        MobTextures.setEntityTexture(item, entity);
        return item;
    }

    private boolean canPickUp(Player player, LivingEntity entity) {
        String name = Utils.getKeyOfEntity((Entity)entity);
        if (this.whitelistedMobs.contains(entity)) {
            return true;
        }
        boolean blacklisted = this.blacklistedMobs.contains(entity);
        if (ClickMobsConfig.CONFIG.get(ClickMobsConfig.PER_MOB_PERMISSIONS).booleanValue()) {
            return Permission.hasPickupPermissionFor((CommandSender)player, name) && !blacklisted;
        }
        return !blacklisted;
    }

    private record ItemResult(ItemStack item, EquipmentSlot slot) {
        void decrementAmount(PlayerInventory inventory) {
            ItemStack item = this.item;
            item.setAmount(item.getAmount() - 1);
            inventory.setItem(this.slot, item);
        }
    }
}

