/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickmobs.predicate;

import de.clickism.clickmobs.predicate.MobPredicate;
import de.clickism.clickmobs.util.Utils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class MobList {
    private final List<MobPredicate> predicates = new ArrayList<MobPredicate>();
    private final Set<String> mobs = new HashSet<String>();

    public boolean contains(LivingEntity entity) {
        String id = Utils.getKeyOfEntity((Entity)entity);
        if (this.mobs.contains(id)) {
            return true;
        }
        return this.predicates.stream().anyMatch(predicate -> predicate.test(entity));
    }

    public void addMob(String identifier) {
        this.mobs.add(identifier);
    }

    public void addPredicate(MobPredicate predicate) {
        this.predicates.add(predicate);
    }

    public void addAll(MobList other) {
        this.mobs.addAll(other.mobs);
        this.predicates.addAll(other.predicates);
    }

    public void clear() {
        this.mobs.clear();
        this.predicates.clear();
    }
}

