/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickmobs.serialization;

import java.io.File;
import java.io.IOException;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public abstract class DataManager {
    protected final JavaPlugin plugin;
    protected final File file;

    public DataManager(JavaPlugin plugin, @NotNull File directory, String fileName) throws IOException {
        this.plugin = plugin;
        DataManager.createDirectoryIfNotExists(directory);
        this.file = new File(directory, fileName);
        if (this.file.exists()) {
            this.load();
        }
    }

    protected static String getTrimmedPath(JavaPlugin plugin, File file) {
        String dataFolderPath = plugin.getDataFolder().getPath();
        String filePath = file.getPath();
        if (filePath.startsWith(dataFolderPath)) {
            return filePath.substring(dataFolderPath.length() + 1);
        }
        return filePath;
    }

    protected static void createDirectoryIfNotExists(File directory) throws IOException {
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException("Failed to create directory " + directory.getPath());
        }
    }

    public abstract void load();
}

