/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickmobs.serialization;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.clickism.clickmobs.serialization.DataManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class JSONDataManager
extends DataManager {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private JsonObject root;

    public JSONDataManager(JavaPlugin plugin, @NotNull File directory, String fileName) throws IOException {
        super(plugin, directory, fileName);
    }

    public void save(JsonObject json) {
        File backupFile = new File(this.file.getPath() + ".old");
        try {
            Files.copy(this.file.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to create backup file: " + backupFile.getPath());
        }
        try (FileWriter writer = new FileWriter(this.file);){
            GSON.toJson((JsonElement)json, (Appendable)writer);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save file: " + this.file.getPath());
        }
    }

    @Override
    public void load() {
        try {
            JsonObject root = (JsonObject)GSON.fromJson((Reader)new FileReader(this.file), JsonObject.class);
            if (root != null) {
                this.root = root;
            }
        }
        catch (FileNotFoundException e) {
            this.plugin.getLogger().warning("File not found: " + this.file.getPath());
        }
    }

    @NotNull
    public JsonObject getRoot() {
        if (this.root == null) {
            this.root = new JsonObject();
        }
        return this.root;
    }
}

