/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickmobs.shadow.de.clickism.configured;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class ConfigOption<T> {
    private final String key;
    private final T defaultValue;
    private final List<Consumer<T>> onLoadListeners = new ArrayList<Consumer<T>>();
    private final Set<String> oldKeys = new HashSet<String>();
    private boolean hidden = false;
    @Nullable
    private String description;
    @Nullable
    private String header;
    @Nullable
    private String footer;

    protected ConfigOption(String key, T defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
    }

    public static <T> ConfigOption<T> ofObject(String key, T defaultValue) {
        return new ConfigOption<T>(key, defaultValue);
    }

    public static ConfigOption<Boolean> of(String key, boolean defaultValue) {
        return ConfigOption.ofObject(key, defaultValue);
    }

    public static <T extends Number> ConfigOption<T> of(String key, T defaultValue) {
        return ConfigOption.ofObject(key, defaultValue);
    }

    public static ConfigOption<String> of(String key, String defaultValue) {
        return ConfigOption.ofObject(key, defaultValue);
    }

    public static ConfigOption<Character> of(String key, char defaultValue) {
        return new ConfigOption<Character>(key, Character.valueOf(defaultValue)){

            @Override
            public Character cast(Object object) throws ClassCastException {
                if (object instanceof Character) {
                    Character character = (Character)object;
                    return character;
                }
                if (object instanceof String) {
                    String string = (String)object;
                    if (string.length() != 1) {
                        throw new ClassCastException("String must be a single character: " + string);
                    }
                    return Character.valueOf(string.charAt(0));
                }
                throw new ClassCastException("Cannot cast into character: " + object.getClass().getName());
            }
        };
    }

    public static <T> ConfigOption<List<T>> of(String key, List<T> defaultValue, final Class<T> elementType) {
        return new ConfigOption<List<T>>(key, defaultValue){

            @Override
            public List<T> cast(Object object) throws ClassCastException {
                if (object instanceof Collection) {
                    Collection collection = (Collection)object;
                    return collection.stream().map(element -> 2.cast(element, elementType)).collect(Collectors.toCollection(ArrayList::new));
                }
                throw new ClassCastException("Cannot cast into list: " + object.getClass().getName());
            }
        };
    }

    public static <T> ConfigOption<Set<T>> of(String key, Set<T> defaultValue, final Class<T> elementType) {
        return new ConfigOption<Set<T>>(key, defaultValue){

            @Override
            public Set<T> cast(Object object) throws ClassCastException {
                if (object instanceof Collection) {
                    Collection collection = (Collection)object;
                    return collection.stream().map(element -> 3.cast(element, elementType)).collect(Collectors.toCollection(LinkedHashSet::new));
                }
                throw new ClassCastException("Cannot cast into set: " + object.getClass().getName());
            }
        };
    }

    public static <K, V> ConfigOption<Map<K, V>> of(String key, Map<K, V> defaultValue, final Class<K> keyType, final Class<V> valueType) {
        return new ConfigOption<Map<K, V>>(key, defaultValue){

            @Override
            public Map<K, V> cast(Object object) throws ClassCastException {
                if (object instanceof Map) {
                    Map map = (Map)object;
                    LinkedHashMap castedMap = new LinkedHashMap(map.size());
                    map.forEach((key, value) -> {
                        Object castedKey = 4.cast(key, keyType);
                        Object castedValue = 4.cast(value, valueType);
                        castedMap.put(castedKey, castedValue);
                    });
                    return castedMap;
                }
                throw new ClassCastException("Cannot cast into map: " + object.getClass().getName());
            }
        };
    }

    private static String formatDefaultValue(Object defaultValue) {
        if (defaultValue instanceof Collection) {
            Collection collection = (Collection)defaultValue;
            return "[" + collection.stream().map(ConfigOption::formatDefaultValue).collect(Collectors.joining(", ")) + "]";
        }
        return String.valueOf(defaultValue);
    }

    protected static <T> T cast(Object object, Class<T> type) throws ClassCastException {
        if (object == null) {
            return null;
        }
        if (type.isInstance(object)) {
            return type.cast(object);
        }
        if (object instanceof Number) {
            Number number = (Number)object;
            if (type == Integer.class) {
                return (T)Integer.valueOf(number.intValue());
            }
            if (type == Long.class) {
                return (T)Long.valueOf(number.longValue());
            }
            if (type == Double.class) {
                return (T)Double.valueOf(number.doubleValue());
            }
            if (type == Float.class) {
                return (T)Float.valueOf(number.floatValue());
            }
            if (type == Short.class) {
                return (T)Short.valueOf(number.shortValue());
            }
            if (type == Byte.class) {
                return (T)Byte.valueOf(number.byteValue());
            }
            throw new ClassCastException("Cannot cast into number type: " + type.getName());
        }
        if (type == Character.class) {
            String string;
            if (object instanceof String && (string = (String)object).length() == 1) {
                return (T)Character.valueOf(string.charAt(0));
            }
            throw new ClassCastException("Cannot cast into character: " + object.getClass().getName());
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            if (type == List.class) {
                return (T)new ArrayList(collection);
            }
            if (type == Set.class) {
                return (T)new LinkedHashSet(collection);
            }
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return (T)new LinkedHashMap(map);
        }
        return type.cast(object);
    }

    public T cast(Object object) throws ClassCastException {
        return (T)ConfigOption.cast(object, this.getType());
    }

    public Class<?> getType() {
        return this.defaultValue.getClass();
    }

    public String key() {
        return this.key;
    }

    public T defaultValue() {
        return this.defaultValue;
    }

    public ConfigOption<T> hidden() {
        this.hidden = true;
        return this;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public ConfigOption<T> onLoad(Consumer<T> listener) {
        this.onLoadListeners.add(listener);
        return this;
    }

    public List<Consumer<T>> onLoadListeners() {
        return this.onLoadListeners;
    }

    @Nullable
    public String description() {
        return this.description;
    }

    public ConfigOption<T> description(String description) {
        this.description = description.trim();
        return this;
    }

    public ConfigOption<T> appendDefaultValue() {
        if (this.description != null) {
            this.description = this.description + "\n";
        }
        this.appendDefaultValueInternal();
        return this;
    }

    public ConfigOption<T> appendInlinedDefaultValue() {
        if (this.description != null) {
            this.description = this.description + " ";
        }
        this.appendDefaultValueInternal();
        return this;
    }

    public ConfigOption<T> appendParenthesizedDefaultValue() {
        if (this.description != null) {
            this.description = this.description + " ";
        }
        this.description = this.description + "(";
        this.appendDefaultValueInternal();
        this.description = this.description + ")";
        return this;
    }

    private void appendDefaultValueInternal() {
        String string = this.description == null ? "" : this.description;
        this.description = string + "Default: " + ConfigOption.formatDefaultValue(this.defaultValue);
    }

    @Nullable
    public String header() {
        return this.header;
    }

    public ConfigOption<T> header(String header) {
        this.header = header.trim();
        return this;
    }

    @Nullable
    public String footer() {
        return this.footer;
    }

    public ConfigOption<T> footer(String footer) {
        this.footer = footer.trim();
        return this;
    }

    public ConfigOption<T> oldKey(String oldKey) {
        this.oldKeys.add(oldKey);
        return this;
    }

    public Set<String> oldKeys() {
        return this.oldKeys;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof ConfigOption)) return false;
        ConfigOption other = (ConfigOption)obj;
        if (!this.key.equals(other.key)) return false;
        return true;
    }
}

