/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickmobs.shadow.de.clickism.configured.format;

import de.clickism.clickmobs.shadow.de.clickism.configured.Config;
import de.clickism.clickmobs.shadow.de.clickism.configured.ConfigOption;
import de.clickism.clickmobs.shadow.de.clickism.configured.format.ConfigFormat;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class BaseFormat
extends ConfigFormat {
    public abstract String formatComment(String var1);

    protected abstract void writeKeyValue(StringBuilder var1, String var2, Object var3, boolean var4) throws Exception;

    protected abstract void writeFormatHeader(StringBuilder var1);

    protected abstract void writeFormatFooter(StringBuilder var1);

    @Override
    public void write(Config config, List<Map.Entry<ConfigOption<?>, Object>> data) throws Exception {
        StringBuilder sb = new StringBuilder();
        this.writeFormatHeader(sb);
        this.writeHeader(sb, config.header());
        this.writeData(sb, data);
        this.writeFooter(sb, config.footer());
        this.writeFormatFooter(sb);
        String string = sb.toString();
        Files.writeString(config.file().toPath(), (CharSequence)string, new OpenOption[0]);
    }

    protected void writeData(StringBuilder sb, List<Map.Entry<ConfigOption<?>, Object>> data) throws Exception {
        Iterator<Map.Entry<ConfigOption<?>, Object>> iterator = data.iterator();
        while (iterator.hasNext()) {
            Map.Entry<ConfigOption<?>, Object> entry = iterator.next();
            ConfigOption<?> option = entry.getKey();
            Object value = entry.getValue();
            this.writeConfigOption(sb, option, value, iterator.hasNext());
        }
    }

    protected void writeConfigOption(StringBuilder sb, ConfigOption<?> option, Object value, boolean hasNext) throws Exception {
        this.writeHeader(sb, option.header());
        this.writeDescription(sb, option.description());
        this.writeKeyValue(sb, option.key(), value, hasNext);
        this.writeFooter(sb, option.footer());
        if (hasNext && this.separateConfigOptions) {
            sb.append('\n');
        }
    }

    protected void writeDescription(StringBuilder sb, @Nullable String description) {
        if (!this.writeComments || description == null) {
            return;
        }
        sb.append(this.formatComment(description)).append('\n');
    }

    protected void writeHeader(StringBuilder sb, @Nullable String header) {
        if (!this.writeComments || header == null) {
            return;
        }
        sb.append(this.formatComment(header)).append("\n\n");
    }

    protected void writeFooter(StringBuilder sb, @Nullable String footer) {
        if (!this.writeComments || footer == null) {
            return;
        }
        sb.append('\n').append(this.formatComment(footer)).append('\n');
    }
}

