/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickmobs.shadow.de.clickism.configured.format;

import de.clickism.clickmobs.shadow.de.clickism.configured.format.ConfigFormat;
import java.util.ServiceLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigFormatProvider {
    private static final StackWalker STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);

    @NotNull
    public static ConfigFormat getFormat(String path, Class<?> caller) throws IllegalArgumentException {
        String extension;
        String string = extension = path.contains(".") ? path.substring(path.lastIndexOf(46) + 1) : null;
        if (extension == null) {
            throw new IllegalArgumentException("Path must have an extension: " + path);
        }
        for (ConfigFormatProvider formatExtension : ConfigFormatProvider.getFormatProviders(caller)) {
            ConfigFormat format = formatExtension.getFormatFor(extension);
            if (format == null) continue;
            return format;
        }
        throw new IllegalArgumentException("No format found for extension: " + extension);
    }

    private static Iterable<ConfigFormatProvider> getFormatProviders(Class<?> caller) {
        ClassLoader classLoader = caller.getClassLoader();
        return ServiceLoader.load(ConfigFormatProvider.class, classLoader);
    }

    public static Class<?> getCallerClass() {
        return STACK_WALKER.walk(frames -> frames.skip(2L).findFirst().map(StackWalker.StackFrame::getDeclaringClass).orElseThrow(() -> new IllegalStateException("Caller class not found")));
    }

    @Nullable
    public abstract ConfigFormat getFormatFor(String var1);
}

