/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickmobs;

import de.clickism.clickmobs.mob.PickupHandler;
import de.clickism.configured.Config;
import de.clickism.configured.ConfigOption;
import java.util.List;

public class ClickMobsConfig {
    public static final Config CONFIG = Config.of((String)"config/ClickMobs/config.yml").version(7).header("---------------------------------------------------------\nClickMobs Config\nNOTE: RELOAD/RESTART SERVER FOR CHANGES TO TAKE EFFECT\n---------------------------------------------------------\n");
    public static final ConfigOption<Boolean> CHECK_UPDATE = CONFIG.optionOf("check_update", true).description("Whether to check for updates on server startup. Strongly Recommended.\n").appendDefaultValue();
    public static final ConfigOption<List<String>> WHITELISTED_MOBS = CONFIG.optionOf("whitelisted_mobs", List.of("cow", "pig", "sheep"), String.class).header("---------------------------------------------------------\nIn the following section you can whitelist/blacklist mobs.\n---------------------------------------------------------\nTo whitelist/blacklist a vanilla mob, add its entity name.\n    i.E: \"creeper\" or \"ender_dragon\"\nTo whitelist/blacklist mobs from other mods, use the full identifier with the namespace.\n    i.E: \"othermod:fancy_creeper\"\n---------------------------------------------------------\nYou can also use tags (predicates) to whitelist/blacklist mobs with certain properties.\nAvailable tags are:\n    ?all, ?hostile, ?baby, ?tamed, ?nametagged, ?silent, ?mob\n\nYou can (optionally) pass arguments to certain tags:\n    - ?nametagged(Dinnerbone)\nYou can combine multiple tags:\n    - ?tamed ?nametagged\nYou can negate tags using \"not\":\n    - not ?hostile\nYou can use the ?mob tag alongside other tags to use tags on specific mobs.\n    - ?mob(creeper, zombie) ?nametagged(Friendly!)\n\nCheck the wiki for more documentation on tags:\nhttps://github.com/Clickism/ClickMobs/wiki/Tags\n---------------------------------------------------------\n").description("Mobs that are allowed to be picked up.\nThe whitelist takes precedence over the blacklist.\n(Blacklisted mobs included in the whitelist will still be allowed)\n").appendDefaultValue();
    public static final ConfigOption<List<String>> BLACKLISTED_MOBS = CONFIG.optionOf("blacklisted_mobs", List.of("?hostile", "wither", "ender_dragon"), String.class).description("Mobs that are not allowed to be picked up.\n").appendDefaultValue();
    public static final ConfigOption<Boolean> ENABLE_DISPENSERS = CONFIG.optionOf("enable_dispensers", true).description("Whether dispensers can dispense picked up mobs.\n").appendDefaultValue();
    public static final ConfigOption<List<String>> BLACKLISTED_ITEMS_IN_HAND = CONFIG.optionOf("blacklisted_items_in_hand", List.of("lead", "saddle"), String.class).description("Items that prevent picking up mobs when held in hand.\nUse the (full) item identifiers of the items.\n\nHarnesses are always blocked for Happy Ghast compatibility\nand do not need to be added here.\n\nUse the tag \"?all\" to block all items. This will make it so players\ncan only pick up mobs with an empty hand.\n\nFor items from another mod, add the namespace before the item name.\n    i.E: \"othermod:otheritem\"\n").appendDefaultValue().onLoad(list -> {
        PickupHandler.BLACKLISTED_MATERIALS_IN_HAND.clear();
        list.forEach(item -> {
            Object name = item.toLowerCase();
            if (!item.contains(":")) {
                name = "minecraft:" + (String)name;
            }
            PickupHandler.BLACKLISTED_MATERIALS_IN_HAND.add((String)name);
        });
    });
}

