/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickmobs.predicate;

import de.clickism.clickmobs.predicate.MobPredicateType;
import java.util.List;
import net.minecraft.class_1309;

public abstract class MobPredicate {
    public static MobPredicate single(MobPredicateType<?> type, List<String> args) {
        return new SinglePredicate(type, args);
    }

    public static MobPredicate negate(MobPredicate predicate) {
        return new NegatedPredicate(predicate);
    }

    public static MobPredicate combine(List<MobPredicate> predicates) {
        return new CompoundPredicate(predicates);
    }

    public abstract boolean test(class_1309 var1);

    public static class SinglePredicate<T>
    extends MobPredicate {
        private final MobPredicateType<T> type;
        private final List<T> args;

        public SinglePredicate(MobPredicateType<T> type, List<String> args) {
            this.type = type;
            this.args = type.parseArgs(args);
        }

        @Override
        public boolean test(class_1309 entity) {
            return this.type.test(entity, this.args);
        }
    }

    public static class NegatedPredicate
    extends MobPredicate {
        private final MobPredicate parent;

        public NegatedPredicate(MobPredicate predicate) {
            this.parent = predicate;
        }

        @Override
        public boolean test(class_1309 entity) {
            return !this.parent.test(entity);
        }
    }

    public static class CompoundPredicate
    extends MobPredicate {
        private final List<MobPredicate> predicates;

        public CompoundPredicate(List<MobPredicate> predicates) {
            this.predicates = predicates;
        }

        @Override
        public boolean test(class_1309 entity) {
            for (MobPredicate predicate : this.predicates) {
                if (predicate.test(entity)) continue;
                return false;
            }
            return true;
        }
    }
}

