/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickmobs;

import de.clickism.clickmobs.ClickMobsConfig;
import de.clickism.clickmobs.callback.MobUseBlockCallback;
import de.clickism.clickmobs.callback.MobUseEntityCallback;
import de.clickism.clickmobs.callback.UpdateNotifier;
import de.clickism.clickmobs.callback.VehicleUseEntityCallback;
import de.clickism.clickmobs.predicate.MobList;
import de.clickism.clickmobs.predicate.MobListParser;
import de.clickism.clickmobs.util.UpdateChecker;
import java.util.List;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3797;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClickMobs
implements ModInitializer {
    public static final String MOD_ID = "clickmobs";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"clickmobs");
    private static String newerVersion = null;

    public void onInitialize() {
        ClickMobsConfig.CONFIG.load();
        MobListParser parser = new MobListParser();
        MobList whitelistedMobs = parser.parseMobList((List)ClickMobsConfig.CONFIG.get(ClickMobsConfig.WHITELISTED_MOBS));
        MobList blacklistedMobs = parser.parseMobList((List)ClickMobsConfig.CONFIG.get(ClickMobsConfig.BLACKLISTED_MOBS));
        UseEntityCallback.EVENT.register((Object)new MobUseEntityCallback(whitelistedMobs, blacklistedMobs));
        UseEntityCallback.EVENT.register((Object)new VehicleUseEntityCallback());
        UseBlockCallback.EVENT.register((Object)new MobUseBlockCallback());
        if (((Boolean)ClickMobsConfig.CONFIG.get(ClickMobsConfig.CHECK_UPDATE)).booleanValue()) {
            this.checkUpdates();
            ServerPlayConnectionEvents.JOIN.register((Object)new UpdateNotifier(() -> newerVersion));
        }
    }

    private void checkUpdates() {
        String modVersion = FabricLoader.getInstance().getModContainer(MOD_ID).map(container -> container.getMetadata().getVersion().getFriendlyString()).orElse(null);
        String minecraftVersion = class_3797.field_25319.comp_4025();
        new UpdateChecker(MOD_ID, "fabric", minecraftVersion).checkVersion(version -> {
            if (modVersion == null || UpdateChecker.getRawVersion(modVersion).equals(version)) {
                return;
            }
            newerVersion = version;
            LOGGER.info("Newer version available: {}", version);
        });
    }

    public static boolean isClickVillagersPresent() {
        return FabricLoader.getInstance().isModLoaded("clickvillagers");
    }
}

