/*
 * Decompiled with CFR 0.152.
 */
package de.clickism.clickmobs.mob;

import de.clickism.clickmobs.mob.MobTextures;
import de.clickism.clickmobs.util.MessageType;
import de.clickism.clickmobs.util.VersionHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class PickupHandler {
    private static final String TYPE_KEY = "EntityType";
    private static final String DATA_KEY = "ClickMobsData";
    private static final String ALL_TAG = "?all";
    public static final Set<String> BLACKLISTED_MATERIALS_IN_HAND = new HashSet<String>();

    public static boolean isBlacklistedItemInHand(class_1792 item) {
        if (BLACKLISTED_MATERIALS_IN_HAND.contains(ALL_TAG) && item != class_1802.field_8162) {
            return true;
        }
        String itemName = class_7923.field_41178.method_10221((Object)item).toString();
        if (itemName.toLowerCase().matches(".*_harness$")) {
            return true;
        }
        return BLACKLISTED_MATERIALS_IN_HAND.contains(item.toString().toLowerCase());
    }

    public static <T extends class_1297> class_1799 toItemStack(T entity) {
        class_2487 nbt = new class_2487();
        entity.method_5647(nbt);
        String id = class_1299.method_5890((class_1299)entity.method_5864()).toString();
        nbt.method_10582(TYPE_KEY, id);
        class_1799 itemStack = PickupHandler.getItemStack((class_2561)PickupHandler.getDisplayName(entity), PickupHandler.getEntityName(entity), nbt);
        MobTextures.setEntityTexture(itemStack, entity);
        entity.method_5650(class_1297.class_5529.field_26999);
        return itemStack;
    }

    private static class_1799 getItemStack(class_2561 name, String entityName, class_2487 nbt) {
        class_1799 itemStack = class_1802.field_8575.method_7854();
        PickupHandler.writeCustomData(itemStack, nbt);
        PickupHandler.formatItem(itemStack, (class_2561)name.method_27661().method_27696(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1054)), List.of(class_2561.method_43470((String)"Right click to place the ").method_10852((class_2561)class_2561.method_43470((String)entityName)).method_27693(" back.").method_27696(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1063))));
        return itemStack;
    }

    private static void writeCustomData(class_1799 itemStack, class_2487 nbt) {
        itemStack.method_7948().method_10566(DATA_KEY, (class_2520)nbt);
    }

    @Nullable
    private static class_2487 readCustomData(class_1799 itemStack) {
        class_2487 nbt = itemStack.method_7969();
        if (nbt == null) {
            return null;
        }
        return nbt.method_10562(DATA_KEY);
    }

    private static void formatItem(class_1799 itemStack, class_2561 name, List<class_2561> lore) {
        class_2499 list = new class_2499();
        lore.forEach(text -> list.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)text))));
        class_2487 display = itemStack.method_7911("display");
        display.method_10566("Lore", (class_2520)list);
        display.method_10566("Name", (class_2520)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)name)));
    }

    public static boolean isMob(class_1799 itemStack) {
        return PickupHandler.readCustomData(itemStack) != null;
    }

    @Nullable
    public static class_1297 readEntityFromItemStack(class_1937 world, class_1799 itemStack) {
        try {
            class_2487 nbt = PickupHandler.readCustomData(itemStack);
            if (nbt == null) {
                return null;
            }
            String id = nbt.method_10558(TYPE_KEY);
            if (id == null) {
                return null;
            }
            class_1299 type = class_1299.method_5898((String)id).orElse(null);
            if (type == null) {
                return null;
            }
            class_1297 entity = type.method_5883(world);
            if (entity == null) {
                return null;
            }
            entity.method_5651(nbt);
            return entity;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class_5250 getDisplayName(class_1297 entity) {
        class_1308 mob;
        if (entity.method_16914()) {
            return class_2561.method_43470((String)"\"").method_10852(entity.method_5797()).method_27693("\"");
        }
        class_2561 name = entity.method_5864().method_5897();
        if (entity instanceof class_1308 && (mob = (class_1308)entity).method_6109()) {
            return class_2561.method_43470((String)"Baby ").method_10852(name);
        }
        return name.method_27661();
    }

    private static String getEntityName(class_1297 entity) {
        return entity.method_5864().method_5897().getString().toLowerCase();
    }

    public static void notifyPickup(class_1657 player, class_1297 entity) {
        String name = entity.method_5864().method_5897().getString().toLowerCase();
        MessageType.PICKUP_MESSAGE.sendActionbarSilently(player, (class_2561)class_2561.method_43470((String)"You picked up a ").method_10852((class_2561)class_2561.method_43470((String)name)));
        class_3218 world = (class_3218)VersionHelper.getWorld((class_1297)player);
        double x = entity.method_23317();
        double y = entity.method_23318() + 0.25;
        double z = entity.method_23321();
        world.method_14199((class_2394)class_2398.field_11227, x, y, z, 1, 0.0, 0.0, 0.0, 1.0);
        VersionHelper.playSound(player, class_3417.field_14706, class_3419.field_15254, 1.0f, 0.5f);
    }
}

