/*
 * Decompiled with CFR 0.152.
 */
package net.plastoid501.movement.gui.widget;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_6379;
import net.minecraft.class_7842;
import net.minecraft.class_7919;
import net.plastoid501.movement.config.Configs;
import net.plastoid501.movement.config.ModConfig;
import net.plastoid501.movement.config.ToggleConfig;
import net.plastoid501.movement.config.json.JToggleConfig;
import net.plastoid501.movement.gui.ConfigScreen;
import net.plastoid501.movement.util.FileUtil;

@Environment(value=EnvType.CLIENT)
public class ConfigWidget
extends class_4265<Entry> {
    final ConfigScreen parent;
    private final class_310 client;
    private final ModConfig CONFIG = Configs.config;

    public ConfigWidget(ConfigScreen parent, class_310 client) {
        super(client, parent.field_22789 + 155, parent.field_22790 - 52, 20, 23);
        this.parent = parent;
        this.client = client;
        this.initEntries(client);
    }

    private void initEntries(class_310 client) {
        if (this.CONFIG != null) {
            this.method_25321((class_350.class_351)new CategoryEntry(class_2561.method_30163((String)"-- Toggle --"), client.field_1772));
            Configs.getToggles().keySet().forEach(key -> this.method_25321((class_350.class_351)new ToggleEntry(this, (String)key, client.field_1772, this.CONFIG)));
            this.method_25321((class_350.class_351)new CategoryEntry(class_2561.method_30163((String)""), client.field_1772));
        }
    }

    public int method_25322() {
        return super.method_25322() + 150;
    }

    public void update() {
        this.updateChildren();
    }

    public void updateChildren() {
        this.method_25396().forEach(Entry::update);
    }

    public class CategoryEntry
    extends Entry {
        private final class_7842 text;
        private final int textWidth;

        CategoryEntry(class_2561 CategoryName, class_327 textRenderer) {
            this.text = new class_7842(CategoryName, textRenderer);
            this.textWidth = this.text.method_25368();
        }

        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)this.text);
        }

        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)this.text);
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.text.method_48229(ConfigWidget.this.client.field_1755.field_22789 / 2 - this.textWidth / 2, y + 5);
            this.text.method_25394(context, mouseX, mouseY, tickDelta);
        }

        @Override
        void update() {
        }
    }

    public class ToggleEntry
    extends Entry {
        private final class_327 textRenderer;
        private final ToggleConfig defaultConfig;
        private boolean enable;
        private final class_7842 text;
        private final class_4185 enableButton;
        private final class_4185 resetButton;

        ToggleEntry(ConfigWidget this$0, String key, class_327 textRenderer, ModConfig config) {
            this.textRenderer = textRenderer;
            this.defaultConfig = Configs.getToggles().get(key);
            this.enable = config.getToggles().get(key).isEnable();
            this.text = new class_7842((class_2561)class_2561.method_43470((String)key), textRenderer);
            this.text.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)this.defaultConfig.getNarrator())));
            this.enableButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.enable ? "ON" : "OFF")).method_10862(class_2583.field_24360.method_36139(this.enable ? Color.GREEN.getRGB() : Color.red.getRGB())), button -> {
                this.enable = !this.enable;
                FileUtil.updateToggleConfig(key, new JToggleConfig(this.enable));
                this.update();
            }).method_46437(60, 20).method_46431();
            this.resetButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"RESET"), button -> {
                this.enable = this.defaultConfig.isEnable();
                FileUtil.updateToggleConfig(key, new JToggleConfig(this.enable));
                this.update();
            }).method_46437(40, 20).method_46431();
            this.resetButton.field_22763 = this.defaultConfig.isEnable() != this.enable;
        }

        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)this.text, (Object)this.enableButton, (Object)this.resetButton);
        }

        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)this.text, (Object)this.enableButton, (Object)this.resetButton);
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.text.method_48229(x - 60, y + 5);
            this.text.method_25394(context, mouseX, mouseY, tickDelta);
            this.enableButton.method_48229(x + 190, y);
            this.resetButton.method_48229(x + 253, y);
            this.enableButton.method_25394(context, mouseX, mouseY, tickDelta);
            this.resetButton.method_25394(context, mouseX, mouseY, tickDelta);
        }

        @Override
        void update() {
            this.enableButton.method_25355((class_2561)class_2561.method_30163((String)(this.enable ? "ON" : "OFF")).method_27661().method_10862(class_2583.field_24360.method_36139(this.enable ? Color.GREEN.getRGB() : Color.red.getRGB())));
            this.resetButton.field_22763 = this.defaultConfig.isEnable() != this.enable;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static abstract class Entry
    extends class_4265.class_4266<Entry> {
        abstract void update();
    }
}

