/*
 * Decompiled with CFR 0.152.
 */
package net.plastoid501.movement.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.plastoid501.movement.MovementInGUI;
import net.plastoid501.movement.config.Configs;
import net.plastoid501.movement.config.ModConfig;
import net.plastoid501.movement.config.ToggleConfig;
import net.plastoid501.movement.config.json.JToggleConfig;

public class FileUtil {
    public static Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir();
    }

    public static void generateClientModConfig() {
        Path path = FileUtil.getConfigPath().resolve("movement-in-gui.json");
        if (Files.exists(path, new LinkOption[0])) {
            return;
        }
        Map<String, JToggleConfig> toggles = Configs.getJToggles();
        ModConfig config = new ModConfig(toggles);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((Object)config);
        try (FileWriter writer = new FileWriter(path.toString());){
            writer.write(json);
        }
        catch (IOException e) {
            MovementInGUI.LOGGER.error(e.getMessage());
        }
    }

    public static void generateClientModConfig(ModConfig config) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((Object)config);
        Path path = FileUtil.getConfigPath().resolve("movement-in-gui.json");
        if (Files.notExists(path, new LinkOption[0])) {
            try (FileWriter writer = new FileWriter(path.toString());){
                writer.write(json);
            }
            catch (IOException e) {
                MovementInGUI.LOGGER.error(e.getMessage());
            }
        }
    }

    public static ModConfig readConfig() {
        ModConfig config;
        Path path = FileUtil.getConfigPath().resolve("movement-in-gui.json");
        Gson gson = new Gson();
        try {
            String jsonContent = Files.readString(path);
            config = (ModConfig)gson.fromJson(jsonContent, ModConfig.class);
        }
        catch (JsonSyntaxException | IOException e) {
            MovementInGUI.LOGGER.error(e.getMessage());
            return Configs.config;
        }
        if (config == null) {
            return Configs.config;
        }
        return config;
    }

    public static void saveConfig(ModConfig config) {
        Path path = FileUtil.getConfigPath().resolve("movement-in-gui.json");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            gson.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            MovementInGUI.LOGGER.error(e.getMessage());
        }
        FileUtil.updateConfigs();
    }

    public static void updateToggleConfig(String target, JToggleConfig toggle) {
        ModConfig config = FileUtil.readConfig();
        Map<String, JToggleConfig> toggleConfigMap = config.getToggles();
        toggleConfigMap.replace(target, toggle);
        FileUtil.saveConfig(config);
    }

    public static void updateConfigs() {
        ModConfig config = FileUtil.readConfig();
        if (config != null) {
            if (config.getToggles() == null) {
                FileUtil.saveConfig(Configs.config);
                return;
            }
            boolean flag = false;
            JToggleConfig toggleConfig = config.getToggles().get(Configs.modEnable.getId());
            if (toggleConfig == null) {
                flag = true;
                toggleConfig = new JToggleConfig(Configs.modEnable.isEnable());
                config.getToggles().put(Configs.modEnable.getId(), toggleConfig);
            }
            Configs.modEnable = new ToggleConfig(Configs.modEnable.getId(), Configs.modEnable.getNarrator(), toggleConfig.isEnable());
            toggleConfig = config.getToggles().get(Configs.inCreative.getId());
            if (toggleConfig == null) {
                flag = true;
                toggleConfig = new JToggleConfig(Configs.inCreative.isEnable());
                config.getToggles().put(Configs.inCreative.getId(), toggleConfig);
            }
            Configs.inCreative = new ToggleConfig(Configs.inCreative.getId(), Configs.inCreative.getNarrator(), toggleConfig.isEnable());
            toggleConfig = config.getToggles().get(Configs.isAnvil.getId());
            if (toggleConfig == null) {
                flag = true;
                toggleConfig = new JToggleConfig(Configs.isAnvil.isEnable());
                config.getToggles().put(Configs.isAnvil.getId(), toggleConfig);
            }
            Configs.isAnvil = new ToggleConfig(Configs.isAnvil.getId(), Configs.isAnvil.getNarrator(), toggleConfig.isEnable());
            toggleConfig = config.getToggles().get(Configs.isMultiplayer.getId());
            if (toggleConfig == null) {
                flag = true;
                toggleConfig = new JToggleConfig(Configs.isMultiplayer.isEnable());
                config.getToggles().put(Configs.isMultiplayer.getId(), toggleConfig);
            }
            Configs.isMultiplayer = new ToggleConfig(Configs.isMultiplayer.getId(), Configs.isMultiplayer.getNarrator(), toggleConfig.isEnable());
            toggleConfig = config.getToggles().get(Configs.forwardKey.getId());
            if (toggleConfig == null) {
                flag = true;
                toggleConfig = new JToggleConfig(Configs.forwardKey.isEnable());
                config.getToggles().put(Configs.forwardKey.getId(), toggleConfig);
            }
            Configs.forwardKey = new ToggleConfig(Configs.forwardKey.getId(), Configs.forwardKey.getNarrator(), toggleConfig.isEnable());
            toggleConfig = config.getToggles().get(Configs.backwardKey.getId());
            if (toggleConfig == null) {
                flag = true;
                toggleConfig = new JToggleConfig(Configs.backwardKey.isEnable());
                config.getToggles().put(Configs.backwardKey.getId(), toggleConfig);
            }
            Configs.backwardKey = new ToggleConfig(Configs.backwardKey.getId(), Configs.backwardKey.getNarrator(), toggleConfig.isEnable());
            toggleConfig = config.getToggles().get(Configs.leftKey.getId());
            if (toggleConfig == null) {
                flag = true;
                toggleConfig = new JToggleConfig(Configs.leftKey.isEnable());
                config.getToggles().put(Configs.leftKey.getId(), toggleConfig);
            }
            Configs.leftKey = new ToggleConfig(Configs.leftKey.getId(), Configs.leftKey.getNarrator(), toggleConfig.isEnable());
            toggleConfig = config.getToggles().get(Configs.rightKey.getId());
            if (toggleConfig == null) {
                flag = true;
                toggleConfig = new JToggleConfig(Configs.rightKey.isEnable());
                config.getToggles().put(Configs.rightKey.getId(), toggleConfig);
            }
            Configs.rightKey = new ToggleConfig(Configs.rightKey.getId(), Configs.rightKey.getNarrator(), toggleConfig.isEnable());
            toggleConfig = config.getToggles().get(Configs.jumpKey.getId());
            if (toggleConfig == null) {
                flag = true;
                toggleConfig = new JToggleConfig(Configs.jumpKey.isEnable());
                config.getToggles().put(Configs.jumpKey.getId(), toggleConfig);
            }
            Configs.jumpKey = new ToggleConfig(Configs.jumpKey.getId(), Configs.jumpKey.getNarrator(), toggleConfig.isEnable());
            toggleConfig = config.getToggles().get(Configs.sneakKey.getId());
            if (toggleConfig == null) {
                flag = true;
                toggleConfig = new JToggleConfig(Configs.sneakKey.isEnable());
                config.getToggles().put(Configs.sneakKey.getId(), toggleConfig);
            }
            Configs.sneakKey = new ToggleConfig(Configs.sneakKey.getId(), Configs.sneakKey.getNarrator(), toggleConfig.isEnable());
            toggleConfig = config.getToggles().get(Configs.sprintKey.getId());
            if (toggleConfig == null) {
                flag = true;
                toggleConfig = new JToggleConfig(Configs.sprintKey.isEnable());
                config.getToggles().put(Configs.sprintKey.getId(), toggleConfig);
            }
            Configs.sprintKey = new ToggleConfig(Configs.sprintKey.getId(), Configs.sprintKey.getNarrator(), toggleConfig.isEnable());
            if (flag) {
                FileUtil.saveConfig(config);
                return;
            }
            Configs.config = config;
        }
    }
}

