/*
 * Decompiled with CFR 0.152.
 */
package me.noramibu.lightup.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayDeque;
import java.util.Queue;
import me.noramibu.lightup.config.config;
import me.noramibu.lightup.model.LightUpType;
import me.noramibu.lightup.task.Task;
import me.noramibu.lightup.task.TaskManager;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2247;
import net.minecraft.class_2257;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public final class LightUpCommand {
    private LightUpCommand() {
    }

    public static void register(TaskManager manager, config config2) {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            LiteralArgumentBuilder root = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"lightup").requires(src -> src.method_9259(2))).then(class_2170.method_9247((String)"reload").executes(ctx -> {
                config2.reload();
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)config2.messageReload), false);
                return 1;
            }))).then(class_2170.method_9247((String)"cancel").executes(ctx -> {
                class_3222 player = ((class_2168)ctx.getSource()).method_44023();
                if (player == null) {
                    return 0;
                }
                manager.cancel(player.method_5667());
                return 1;
            }))).then(class_2170.method_9247((String)"undo").executes(ctx -> {
                class_3222 player = ((class_2168)ctx.getSource()).method_44023();
                if (player == null) {
                    return 0;
                }
                boolean ok = manager.undo(player);
                if (!ok) {
                    player.method_43496((class_2561)class_2561.method_43470((String)"Nothing to undo."));
                }
                return 1;
            }))).then(class_2170.method_9244((String)"block", (ArgumentType)class_2257.method_9653((class_7157)registryAccess)).then(class_2170.method_9244((String)"min_light_level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)15)).then(class_2170.method_9244((String)"range", (ArgumentType)IntegerArgumentType.integer((int)0)).then(class_2170.method_9244((String)"include_skylight", (ArgumentType)BoolArgumentType.bool()).then(class_2170.method_9244((String)"lightup_type", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> {
                builder.suggest("surface");
                builder.suggest("cave");
                builder.suggest("all");
                return builder.buildFuture();
            }).executes(ctx -> LightUpCommand.execute((CommandContext<class_2168>)ctx, manager, config2)))))));
            dispatcher.register(root);
            dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"lu").redirect(dispatcher.getRoot().getChild("lightup")));
        });
    }

    private static int execute(CommandContext<class_2168> ctx, TaskManager manager, config config2) {
        LightUpType type;
        class_2168 source = (class_2168)ctx.getSource();
        class_3222 player = source.method_44023();
        if (player == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Only players can use this command."));
            return 0;
        }
        if (manager.hasActiveTask(player.method_5667())) {
            player.method_43496((class_2561)class_2561.method_43470((String)"Please wait for the current Light Up task to complete."));
            return 1;
        }
        class_2247 parsed = class_2257.method_9655(ctx, (String)"block");
        class_2680 state = parsed.method_9494();
        int min = IntegerArgumentType.getInteger(ctx, (String)"min_light_level");
        int range = IntegerArgumentType.getInteger(ctx, (String)"range");
        boolean includeSky = BoolArgumentType.getBool(ctx, (String)"include_skylight");
        String typeStr = StringArgumentType.getString(ctx, (String)"lightup_type");
        try {
            type = LightUpType.valueOf(typeStr.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            type = LightUpType.ALL;
        }
        class_3218 world = source.method_9225();
        class_2338 origin = player.method_24515();
        Queue<class_2338> blocks = LightUpCommand.collectBlocks((class_1937)world, origin, range);
        Task task = new Task(player.method_5667(), (class_1937)world, state, min, includeSky, type, blocks, config2.maxBlocksPerTick, source, config2.progressActionBarEnabled, config2.progressActionBarFormatting);
        manager.createTask(player, (class_1937)world, task);
        return 1;
    }

    private static Queue<class_2338> collectBlocks(class_1937 world, class_2338 origin, int distanceMax) {
        ArrayDeque<class_2338> blocks = new ArrayDeque<class_2338>();
        int minY = Math.max(world.method_31607(), origin.method_10264() - distanceMax);
        int topAtOrigin = world.method_8624(class_2902.class_2903.field_13202, origin.method_10263(), origin.method_10260());
        int maxY = Math.min(topAtOrigin, origin.method_10264() + distanceMax);
        for (int y = minY; y <= maxY; ++y) {
            for (int x = origin.method_10263() - distanceMax; x <= origin.method_10263() + distanceMax; ++x) {
                for (int z = origin.method_10260() - distanceMax; z <= origin.method_10260() + distanceMax; ++z) {
                    blocks.add(new class_2338(x, y, z));
                }
            }
        }
        return blocks;
    }
}

