/*
 * Decompiled with CFR 0.152.
 */
package me.noramibu.lightup.task;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.noramibu.lightup.task.Task;
import me.noramibu.lightup.util.BlockUtils;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class TaskManager {
    private final Map<UUID, Task> playerTasks = new HashMap<UUID, Task>();
    private final Map<UUID, Deque<List<class_2338>>> playerUndo = new HashMap<UUID, Deque<List<class_2338>>>();

    public void ensureUndoStack(UUID uuid) {
        this.playerUndo.computeIfAbsent(uuid, k -> new ArrayDeque());
    }

    public boolean hasActiveTask(UUID uuid) {
        return this.playerTasks.containsKey(uuid);
    }

    public void cancel(UUID uuid) {
        Task t = this.playerTasks.get(uuid);
        if (t != null) {
            t.cancelled = true;
        }
    }

    public void createTask(class_3222 player, class_1937 world, Task task) {
        this.playerTasks.put(player.method_5667(), task);
        task.commandSource.method_9226(() -> class_2561.method_43470((String)("Light Up started. Scanning " + task.totalBlocks + " blocks...")), false);
    }

    public void tick(MinecraftServer server) {
        for (Task task : new ArrayList<Task>(this.playerTasks.values())) {
            class_2338 pos;
            if (task.cancelled) {
                this.finish(server, task, true);
                continue;
            }
            int processed = 0;
            while (!task.blocks.isEmpty() && processed < task.maxBlocksPerTick && (pos = task.blocks.poll()) != null) {
                int lightLevel;
                if (!BlockUtils.isValidPlacement(task.world, pos, task.type) || (lightLevel = task.includeSkylight ? task.world.method_22339(pos) : task.world.method_8314(class_1944.field_9282, pos)) >= task.minLightLevel) continue;
                if (task.world.method_8652(pos, task.blockState, 3)) {
                    ++task.placed;
                    task.currentPlacementRecord.add(pos);
                    if (task.progressEnabled) {
                        int scanned = task.totalBlocks - task.blocks.size();
                        int percentage = Math.round((1.0f - (float)task.blocks.size() / (float)task.totalBlocks) * 100.0f);
                        String msg = task.actionBarFormat.replace("{ScannedBlocks}", String.valueOf(scanned)).replace("{TotalBlocks}", String.valueOf(task.totalBlocks)).replace("{PlacedLights}", String.valueOf(task.placed)).replace("{CompletedPercentage}", String.valueOf(percentage));
                        class_3222 player = server.method_3760().method_14602(task.playerUuid);
                        if (player != null) {
                            player.method_7353((class_2561)class_2561.method_43470((String)msg).method_27692(class_124.field_1054), true);
                        }
                    }
                    ++processed;
                    break;
                }
                ++processed;
            }
            if (!task.blocks.isEmpty()) continue;
            this.finish(server, task, false);
        }
    }

    private void finish(MinecraftServer server, Task task, boolean cancelled) {
        this.playerTasks.remove(task.playerUuid);
        if (!task.currentPlacementRecord.isEmpty()) {
            this.playerUndo.computeIfAbsent(task.playerUuid, k -> new ArrayDeque()).addLast(task.currentPlacementRecord);
        }
        boolean cancelledFinal = cancelled;
        task.commandSource.method_9226(() -> class_2561.method_43470((String)(cancelledFinal ? "Light up task cancelled" : "Light Up complete. Scanned " + task.totalBlocks + ", Placed " + task.placed + ".")), false);
    }

    public boolean undo(class_3222 player) {
        Deque stack = this.playerUndo.computeIfAbsent(player.method_5667(), k -> new ArrayDeque());
        if (stack.isEmpty()) {
            return false;
        }
        List last = (List)stack.removeLast();
        class_3218 world = player.method_64396().method_9225();
        for (class_2338 pos : last) {
            world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
        }
        return true;
    }
}

