/*
 * Decompiled with CFR 0.152.
 */
package me.noramibu.lightup.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public final class config {
    public String messageReload = config.translate("&aLight Up has been reloaded!");
    public String messageOnlyPlayerCommand = config.translate("&cThis command can only be executed by a player");
    public String messageNoActiveTask = config.translate("&eThere is no active light up tasks");
    public String messageNothingToUndo = config.translate("&cThere is nothing to undo");
    public String messageWaitComplete = config.translate("&ePlease wait while your current light up task to complete or cancelled!");
    public String messageLightUpBegin = config.translate("&7Please wait while we light up your surroundings!");
    public String messageLightUpCompleteTemplate = config.translate("&aSuccessfully lid up &b{TotalBlocks} &ablocks with &e{TotalPlaced} &alight sources placed!");
    public String messageLightUpCancelled = config.translate("&cLight up task cancelled");
    public String messageUndoUnloadedWorld = config.translate("&cUndo cancelled! Destination world is not loaded!");
    public String messageUndoCompleteTemplate = config.translate("&dLast light up task had been undone, reverted {BlocksUndone} light sources!");
    public int maxBlocksPerTick = 4000;
    public boolean progressActionBarEnabled = true;
    public String progressActionBarFormatting = config.translate("&eLight Up Task: &a{ScannedBlocks}&b/{TotalBlocks} {CompletedPercentage}% &e({PlacedLights} lights placed)");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = Paths.get("config", "light-up.json");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static config loadOrCreate() {
        config cfg = new config();
        try {
            if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
                Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
                config.write(cfg);
                return cfg;
            }
            try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH, StandardCharsets.UTF_8);){
                JsonObject root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                if (root == null) {
                    config config2 = cfg;
                    return config2;
                }
                JsonObject messages = root.has("messages") && root.get("messages").isJsonObject() ? root.getAsJsonObject("messages") : new JsonObject();
                JsonObject options = root.has("options") && root.get("options").isJsonObject() ? root.getAsJsonObject("options") : new JsonObject();
                cfg.messageReload = config.getOr(messages, "reload", cfg.messageReload);
                cfg.messageOnlyPlayerCommand = config.getOr(messages, "onlyPlayerCommand", cfg.messageOnlyPlayerCommand);
                cfg.messageNoActiveTask = config.getOr(messages, "noActiveTask", cfg.messageNoActiveTask);
                cfg.messageNothingToUndo = config.getOr(messages, "nothingToUndo", cfg.messageNothingToUndo);
                cfg.messageWaitComplete = config.getOr(messages, "waitComplete", cfg.messageWaitComplete);
                cfg.messageLightUpBegin = config.getOr(messages, "lightUpBegin", cfg.messageLightUpBegin);
                cfg.messageLightUpCompleteTemplate = config.getOr(messages, "lightUpComplete", cfg.messageLightUpCompleteTemplate);
                cfg.messageLightUpCancelled = config.getOr(messages, "lightUpCancelled", cfg.messageLightUpCancelled);
                cfg.messageUndoUnloadedWorld = config.getOr(messages, "undoUnloadedWorld", cfg.messageUndoUnloadedWorld);
                cfg.messageUndoCompleteTemplate = config.getOr(messages, "undoComplete", cfg.messageUndoCompleteTemplate);
                cfg.maxBlocksPerTick = options.has("maxBlocksPerTick") ? options.get("maxBlocksPerTick").getAsInt() : cfg.maxBlocksPerTick;
                cfg.progressActionBarEnabled = options.has("progressActionBarEnabled") && options.get("progressActionBarEnabled").getAsBoolean();
                cfg.progressActionBarFormatting = config.getOr(options, "progressActionBarFormatting", cfg.progressActionBarFormatting);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            config.write(cfg);
            return cfg;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return cfg;
    }

    public void reload() {
        try {
            if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
                return;
            }
            try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH, StandardCharsets.UTF_8);){
                JsonObject root = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                if (root == null) {
                    return;
                }
                JsonObject messages = root.has("messages") && root.get("messages").isJsonObject() ? root.getAsJsonObject("messages") : new JsonObject();
                JsonObject options = root.has("options") && root.get("options").isJsonObject() ? root.getAsJsonObject("options") : new JsonObject();
                this.messageReload = config.getOr(messages, "reload", this.messageReload);
                this.messageOnlyPlayerCommand = config.getOr(messages, "onlyPlayerCommand", this.messageOnlyPlayerCommand);
                this.messageNoActiveTask = config.getOr(messages, "noActiveTask", this.messageNoActiveTask);
                this.messageNothingToUndo = config.getOr(messages, "nothingToUndo", this.messageNothingToUndo);
                this.messageWaitComplete = config.getOr(messages, "waitComplete", this.messageWaitComplete);
                this.messageLightUpBegin = config.getOr(messages, "lightUpBegin", this.messageLightUpBegin);
                this.messageLightUpCompleteTemplate = config.getOr(messages, "lightUpComplete", this.messageLightUpCompleteTemplate);
                this.messageLightUpCancelled = config.getOr(messages, "lightUpCancelled", this.messageLightUpCancelled);
                this.messageUndoUnloadedWorld = config.getOr(messages, "undoUnloadedWorld", this.messageUndoUnloadedWorld);
                this.messageUndoCompleteTemplate = config.getOr(messages, "undoComplete", this.messageUndoCompleteTemplate);
                this.maxBlocksPerTick = options.has("maxBlocksPerTick") ? options.get("maxBlocksPerTick").getAsInt() : this.maxBlocksPerTick;
                this.progressActionBarEnabled = options.has("progressActionBarEnabled") && options.get("progressActionBarEnabled").getAsBoolean();
                this.progressActionBarFormatting = config.getOr(options, "progressActionBarFormatting", this.progressActionBarFormatting);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void write(config cfg) throws IOException {
        JsonObject root = new JsonObject();
        JsonObject messages = new JsonObject();
        messages.addProperty("reload", cfg.messageReload);
        messages.addProperty("onlyPlayerCommand", cfg.messageOnlyPlayerCommand);
        messages.addProperty("noActiveTask", cfg.messageNoActiveTask);
        messages.addProperty("nothingToUndo", cfg.messageNothingToUndo);
        messages.addProperty("waitComplete", cfg.messageWaitComplete);
        messages.addProperty("lightUpBegin", cfg.messageLightUpBegin);
        messages.addProperty("lightUpComplete", cfg.messageLightUpCompleteTemplate);
        messages.addProperty("lightUpCancelled", cfg.messageLightUpCancelled);
        messages.addProperty("undoUnloadedWorld", cfg.messageUndoUnloadedWorld);
        messages.addProperty("undoComplete", cfg.messageUndoCompleteTemplate);
        JsonObject options = new JsonObject();
        options.addProperty("maxBlocksPerTick", (Number)cfg.maxBlocksPerTick);
        options.addProperty("progressActionBarEnabled", Boolean.valueOf(cfg.progressActionBarEnabled));
        options.addProperty("progressActionBarFormatting", cfg.progressActionBarFormatting);
        root.add("messages", (JsonElement)messages);
        root.add("options", (JsonElement)options);
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, StandardCharsets.UTF_8, new OpenOption[0]);){
            GSON.toJson((JsonElement)root, (Appendable)writer);
        }
    }

    public String formatComplete(int totalBlocks, int totalPlaced) {
        return this.messageLightUpCompleteTemplate.replace("{TotalBlocks}", String.valueOf(totalBlocks)).replace("{TotalPlaced}", String.valueOf(totalPlaced));
    }

    public String formatUndoComplete(int blocksUndone) {
        return this.messageUndoCompleteTemplate.replace("{BlocksUndone}", String.valueOf(blocksUndone));
    }

    private static String translate(String s) {
        return s.replace('&', '\u00a7');
    }

    private static String getOr(JsonObject obj, String key, String def) {
        return obj.has(key) ? obj.get(key).getAsString() : def;
    }
}

