/*
 * Decompiled with CFR 0.152.
 */
package ca.techgarage.scrublifehelper.util;

import ca.techgarage.scrublifehelper.util.LivesColorHelper;
import ca.techgarage.scrublifehelper.util.TabNameColorHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;

public class LivesManager {
    private static final Map<UUID, Integer> livesMap = new HashMap<UUID, Integer>();
    private static final String LIVES_DATA_FILE = "scrublife_lives.dat";
    private static MinecraftServer serverInstance;

    public static void initialize(MinecraftServer server) {
        serverInstance = server;
        LivesManager.loadLivesData();
    }

    public static void loadLivesData() {
        if (serverInstance == null) {
            return;
        }
        try {
            Path worldPath = serverInstance.m_129843_(LevelResource.f_78182_);
            File livesFile = worldPath.resolve(LIVES_DATA_FILE).toFile();
            if (!livesFile.exists()) {
                return;
            }
            CompoundTag tag = NbtIo.m_128937_((File)livesFile);
            livesMap.clear();
            for (String key : tag.m_128431_()) {
                try {
                    UUID uuid = UUID.fromString(key);
                    int lives = tag.m_128451_(key);
                    livesMap.put(uuid, lives);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        catch (IOException e) {
            System.err.println("Failed to load lives data: " + e.getMessage());
        }
    }

    public static void saveLivesData() {
        if (serverInstance == null) {
            return;
        }
        try {
            Path worldPath = serverInstance.m_129843_(LevelResource.f_78182_);
            File livesFile = worldPath.resolve(LIVES_DATA_FILE).toFile();
            CompoundTag tag = new CompoundTag();
            for (Map.Entry<UUID, Integer> entry : livesMap.entrySet()) {
                tag.m_128405_(entry.getKey().toString(), entry.getValue().intValue());
            }
            NbtIo.m_128944_((CompoundTag)tag, (File)livesFile);
        }
        catch (IOException e) {
            System.err.println("Failed to save lives data: " + e.getMessage());
        }
    }

    public static void updatePlayerNameColor(ServerPlayer player) {
        int lives = LivesManager.getLives(player);
        Component coloredName = LivesColorHelper.getColoredName(player.m_7755_().getString(), lives);
        player.m_6593_(coloredName);
        player.m_20340_(true);
    }

    public static int getLives(ServerPlayer player) {
        return livesMap.getOrDefault(player.m_20148_(), 3);
    }

    public static void setLives(ServerPlayer player, int lives) {
        livesMap.put(player.m_20148_(), lives);
        TabNameColorHelper.updatePlayerTabColor(player, lives);
        LivesManager.saveLivesData();
    }

    public static void decrementLife(ServerPlayer player) {
        livesMap.put(player.m_20148_(), LivesManager.getLives(player) - 1);
        int lives = LivesManager.getLives(player);
        TabNameColorHelper.updatePlayerTabColor(player, lives);
        LivesManager.saveLivesData();
    }

    public static boolean giveLife(ServerPlayer giver, ServerPlayer receiver) {
        if (LivesManager.getLives(giver) <= 1) {
            return false;
        }
        LivesManager.decrementLife(giver);
        LivesManager.addLife(receiver);
        return true;
    }

    public static void addLife(ServerPlayer player) {
        int lives = LivesManager.getLives(player);
        livesMap.put(player.m_20148_(), lives + 1);
        TabNameColorHelper.updatePlayerTabColor(player, lives + 1);
        LivesManager.saveLivesData();
    }

    public static void randomizeLives(ServerPlayer player) {
        int randomLives = (int)(Math.random() * 5.0) + 2;
        LivesManager.setLives(player, randomLives);
    }

    public static List<ServerPlayer> getDeadPlayers(MinecraftServer server) {
        return livesMap.entrySet().stream().filter(entry -> (Integer)entry.getValue() <= 0).map(entry -> LivesManager.getServerPlayer(server, (UUID)entry.getKey())).filter(player -> player != null).collect(Collectors.toList());
    }

    private static ServerPlayer getServerPlayer(MinecraftServer server, UUID uuid) {
        return server.m_6846_().m_11259_(uuid);
    }

    public static void onServerStopping() {
        LivesManager.saveLivesData();
    }

    public static void clearAllLives() {
        livesMap.clear();
        LivesManager.saveLivesData();
    }
}

