/*
 * Decompiled with CFR 0.152.
 */
package ca.techgarage.scrublifehelper.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TitleHelper {
    private static final Map<UUID, DelayedTitle> delayedTitles = new HashMap<UUID, DelayedTitle>();

    public static void sendTitle(ServerPlayer player, Component title, int fadeIn, int stay, int fadeOut) {
        player.f_8906_.m_9829_((Packet)new ClientboundSetTitlesAnimationPacket(fadeIn, stay, fadeOut));
        player.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket(title));
    }

    public static void sendBoogeymanResult(ServerPlayer player, boolean isBoogeyman) {
        TitleHelper.sendTitle(player, (Component)Component.m_237115_((String)"You are...").m_130938_(style -> style.m_131136_(Boolean.valueOf(true))), 15, 35, 5);
        player.m_6330_(SoundEvents.f_12493_, SoundSource.PLAYERS, 1.0f, 0.5f);
        delayedTitles.put(player.m_20148_(), new DelayedTitle(player, isBoogeyman, 65));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        Iterator<Map.Entry<UUID, DelayedTitle>> iter = delayedTitles.entrySet().iterator();
        while (iter.hasNext()) {
            DelayedTitle delayed = iter.next().getValue();
            --delayed.ticksLeft;
            if (delayed.ticksLeft > 0) continue;
            if (delayed.isBoogeyman) {
                TitleHelper.sendTitle(delayed.player, (Component)Component.m_237115_((String)"The Boogeyman").m_130938_(style -> style.m_178520_(0xFF0000)), 10, 70, 20);
                delayed.player.m_6330_(SoundEvents.f_12563_, SoundSource.PLAYERS, 1.0f, 1.0f);
            } else {
                TitleHelper.sendTitle(delayed.player, (Component)Component.m_237115_((String)"NOT the Boogeyman").m_130938_(style -> style.m_178520_(0x55FF55)), 10, 70, 20);
                delayed.player.m_6330_(SoundEvents.f_11860_, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            iter.remove();
        }
    }

    private static class DelayedTitle {
        public final ServerPlayer player;
        public final boolean isBoogeyman;
        public int ticksLeft;

        public DelayedTitle(ServerPlayer player, boolean isBoogeyman, int ticks) {
            this.player = player;
            this.isBoogeyman = isBoogeyman;
            this.ticksLeft = ticks;
        }
    }
}

