/*
 * Decompiled with CFR 0.152.
 */
package ca.techgarage.scrublifehelper.commands;

import ca.techgarage.scrublifehelper.util.LivesManager;
import ca.techgarage.scrublifehelper.util.TitleHelper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;

public class RandomizeLivesCommand {
    private static final int ROLL_COUNT = 16;
    private static final int TICK_DELAY = 5;
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"randomizelives").requires(src -> src.m_6761_(2))).executes(ctx -> {
            MinecraftServer server = ((CommandSourceStack)ctx.getSource()).m_81377_();
            for (ServerPlayer player : server.m_6846_().m_11314_()) {
                RandomizeLivesCommand.rollLives(player, 0);
            }
            return 1;
        }));
    }

    private static void rollLives(ServerPlayer player, int currentRoll) {
        if (currentRoll >= 16) {
            LivesManager.randomizeLives(player);
            int finalLives = LivesManager.getLives(player);
            TitleHelper.sendTitle(player, (Component)Component.m_237113_((String)("Your lives: " + finalLives)).m_130938_(style -> style.m_131136_(Boolean.valueOf(true)).m_131140_(RandomizeLivesCommand.getColor(finalLives))), 20, 70, 20);
            return;
        }
        int tempLives = (int)(Math.random() * 5.0) + 2;
        TitleHelper.sendTitle(player, (Component)Component.m_237113_((String)("" + tempLives)).m_130938_(style -> style.m_131136_(Boolean.valueOf(true)).m_131140_(RandomizeLivesCommand.getColor(tempLives))), 10, 20, 10);
        player.m_6330_(SoundEvents.f_11762_, SoundSource.PLAYERS, 1.0f, 1.0f);
        scheduler.schedule(() -> RandomizeLivesCommand.rollLives(player, currentRoll + 1), 250L, TimeUnit.MILLISECONDS);
    }

    private static ChatFormatting getColor(int lives) {
        if (lives == 2) {
            return ChatFormatting.YELLOW;
        }
        if (lives == 3) {
            return ChatFormatting.GREEN;
        }
        if (lives >= 4) {
            return ChatFormatting.DARK_GREEN;
        }
        return ChatFormatting.WHITE;
    }
}

