/*
 * Decompiled with CFR 0.152.
 */
package ca.techgarage.scrublifehelper.events;

import ca.techgarage.scrublifehelper.commands.BoogeymanCommand;
import ca.techgarage.scrublifehelper.util.ColorHelper;
import ca.techgarage.scrublifehelper.util.LightningHelper;
import ca.techgarage.scrublifehelper.util.LivesManager;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PlayerEvents {
    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        ServerPlayer boogeyman;
        ServerPlayer killer;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        LivesManager.decrementLife(player);
        int lives = LivesManager.getLives(player);
        if (lives <= 0) {
            LightningHelper.strikeLightningNoFire(player);
            player.m_213846_((Component)Component.m_237113_((String)"You are out of lives...").m_130940_(ChatFormatting.GRAY));
            player.m_143403_(GameType.SPECTATOR);
        }
        PlayerEvents.updatePlayerName(player);
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof ServerPlayer && (killer = (ServerPlayer)entity).equals((Object)(boogeyman = BoogeymanCommand.getBoogeyman())) && lives >= 1) {
            killer.m_213846_((Component)Component.m_237113_((String)"You have cured yourself as the Boogeyman!").m_130940_(ChatFormatting.RED));
            BoogeymanCommand.clearBoogeyman();
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        int lives = LivesManager.getLives(player2);
        PlayerEvents.updatePlayerName(player2);
    }

    private static void updatePlayerName(ServerPlayer player) {
        int lives = LivesManager.getLives(player);
        ChatFormatting color = ColorHelper.getColorForLives(lives);
        player.m_6593_((Component)Component.m_237113_((String)player.m_36316_().getName()).m_130940_(color));
        player.m_20340_(true);
    }
}

