/*
 * Decompiled with CFR 0.152.
 */
package ca.techgarage.scrublifehelper.util;

import ca.techgarage.scrublifehelper.util.LivesColorHelper;
import ca.techgarage.scrublifehelper.util.TabNameColorHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class LivesManager {
    private static final Map<UUID, Integer> livesMap = new HashMap<UUID, Integer>();

    public static void updatePlayerNameColor(ServerPlayer player) {
        int lives = LivesManager.getLives(player);
        Component coloredName = LivesColorHelper.getColoredName(player.m_7755_().getString(), lives);
        player.m_6593_(coloredName);
        player.m_20340_(true);
    }

    public static int getLives(ServerPlayer player) {
        return livesMap.getOrDefault(player.m_20148_(), 3);
    }

    public static void setLives(ServerPlayer player, int lives) {
        livesMap.put(player.m_20148_(), lives);
        TabNameColorHelper.updatePlayerTabColor(player, lives);
    }

    public static void decrementLife(ServerPlayer player) {
        livesMap.put(player.m_20148_(), LivesManager.getLives(player) - 1);
        int lives = LivesManager.getLives(player);
        TabNameColorHelper.updatePlayerTabColor(player, lives);
    }

    public static boolean giveLife(ServerPlayer giver, ServerPlayer receiver) {
        if (LivesManager.getLives(giver) <= 1) {
            return false;
        }
        LivesManager.decrementLife(giver);
        LivesManager.addLife(receiver);
        return true;
    }

    public static void addLife(ServerPlayer player) {
        int lives = LivesManager.getLives(player);
        livesMap.put(player.m_20148_(), lives + 1);
        TabNameColorHelper.updatePlayerTabColor(player, lives);
    }

    public static void randomizeLives(ServerPlayer player) {
        int randomLives = (int)(Math.random() * 5.0) + 2;
        LivesManager.setLives(player, randomLives);
    }

    public static List<ServerPlayer> getDeadPlayers(MinecraftServer server) {
        return livesMap.entrySet().stream().filter(entry -> (Integer)entry.getValue() <= 0).map(entry -> LivesManager.getServerPlayer(server, (UUID)entry.getKey())).filter(player -> player != null).collect(Collectors.toList());
    }

    private static ServerPlayer getServerPlayer(MinecraftServer server, UUID uuid) {
        return server.m_6846_().m_11259_(uuid);
    }
}

