/*
 * Decompiled with CFR 0.152.
 */
package com.karpen.simpleEffects.commands;

import com.karpen.simpleEffects.model.Config;
import com.karpen.simpleEffects.services.Effects;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Eff
implements CommandExecutor {
    private final Config config;
    private final Effects effects;

    public Eff(Config config, Effects effects) {
        this.config = config;
        this.effects = effects;
    }

    public boolean onCommand(CommandSender commandSender, Command command, String s, String[] strings) {
        if (!(commandSender instanceof Player)) {
            commandSender.sendMessage(String.valueOf(ChatColor.RED) + this.config.getErrConsole());
            return true;
        }
        if (this.config == null) {
            commandSender.sendMessage(String.valueOf(ChatColor.RED) + "\u041a\u043e\u043d\u0444\u0438\u0433 \u043d\u0435 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043b\u0441\u044f");
            return true;
        }
        Player player = (Player)commandSender;
        if (strings.length == 0) {
            player.sendMessage(String.valueOf(ChatColor.RED) + this.config.getErrArgs());
            return true;
        }
        return switch (strings[0].toLowerCase()) {
            case "cherry" -> this.activeCherry(player);
            case "endrod" -> this.activeEndRod(player);
            case "totem" -> this.activeTotem(player);
            default -> this.errCommand(player);
        };
    }

    private boolean activeCherry(Player player) {
        if (this.effects.cherryPlayers.contains(player)) {
            this.effects.cherryPlayers.remove(player);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + this.config.getMsgDisCherry());
        } else {
            this.effects.cherryPlayers.add(player);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + this.config.getMsgCherry());
        }
        return true;
    }

    private boolean activeEndRod(Player player) {
        if (this.effects.endRodPlayers.contains(player)) {
            this.effects.endRodPlayers.remove(player);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + this.config.getMsgDisEndRod());
        } else {
            this.effects.endRodPlayers.add(player);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + this.config.getMsgEndRod());
        }
        return true;
    }

    private boolean activeTotem(Player player) {
        if (this.effects.totemPlayers.contains(player)) {
            this.effects.totemPlayers.remove(player);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + this.config.getMsgDisTotem());
        } else {
            this.effects.totemPlayers.add(player);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + this.config.getMsgTotem());
        }
        return true;
    }

    private boolean errCommand(Player player) {
        player.sendMessage(String.valueOf(ChatColor.RED) + this.config.getErrCommand());
        return true;
    }
}

