/*
 * Decompiled with CFR 0.152.
 */
package com.karpen.simpleEffects.listeners;

import com.karpen.simpleEffects.services.Effects;
import java.util.Set;
import org.bukkit.Particle;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class MainListener
implements Listener {
    private final Effects effects;

    public MainListener(Effects effects) {
        this.effects = effects;
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.effects.cherryPlayers.contains(player)) {
            this.effects.savePlayers(Set.of(player), "cherry");
        }
        if (this.effects.endRodPlayers.contains(player)) {
            this.effects.savePlayers(Set.of(player), "endrod");
        }
        if (this.effects.totemPlayers.contains(player)) {
            this.effects.savePlayers(Set.of(player), "totem");
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.effects.loadPlayers();
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        double oldX = event.getFrom().getX();
        double oldY = event.getFrom().getY();
        double oldZ = event.getFrom().getZ();
        double newX = event.getTo().getX();
        double newY = event.getTo().getY();
        double newZ = event.getTo().getZ();
        if (oldX != newX || oldY != newY || oldZ != newZ) {
            if (this.effects.cherryPlayers.contains(player)) {
                this.effects.spawnEffect(player.getLocation(), Particle.CHERRY_LEAVES);
            }
            if (this.effects.endRodPlayers.contains(player)) {
                this.effects.spawnEffect(player.getLocation(), Particle.END_ROD);
            }
            if (this.effects.totemPlayers.contains(player)) {
                this.effects.spawnEffect(player.getLocation(), Particle.TOTEM_OF_UNDYING);
            }
        }
    }
}

