/*
 * Decompiled with CFR 0.152.
 */
package com.karpen.simpleEffects.services;

import com.karpen.simpleEffects.SimpleEffects;
import com.karpen.simpleEffects.model.Config;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.entity.Player;

public class Effects {
    private final SimpleEffects plugin;
    private final File datafile;
    public final Set<Player> cherryPlayers = new HashSet<Player>();
    public final Set<Player> endRodPlayers = new HashSet<Player>();
    public final Set<Player> totemPlayers = new HashSet<Player>();

    public Effects(SimpleEffects plugin) {
        this.plugin = plugin;
        this.datafile = new File(plugin.getDataFolder(), "players.txt");
        if (!plugin.getDataFolder().exists()) {
            plugin.getDataFolder().mkdirs();
        }
    }

    public void savePlayers(Set<Player> players, String playerType) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.datafile, true));){
            for (Player player : players) {
                writer.write(player.getUniqueId().toString() + "," + playerType);
                writer.newLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Set<Player> loadPlayers() {
        HashSet<Player> players = new HashSet<Player>();
        if (!this.datafile.exists()) {
            return players;
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(this.datafile));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] parts = line.split(",");
                if (parts.length != 2) continue;
                String uuidString = parts[0];
                String playerType = parts[1];
                Player player = this.plugin.getServer().getPlayer(UUID.fromString(uuidString));
                if (player == null) continue;
                switch (playerType) {
                    case "cherry": {
                        this.cherryPlayers.add(player);
                        break;
                    }
                    case "endrod": {
                        this.endRodPlayers.add(player);
                        break;
                    }
                    case "totem": {
                        this.totemPlayers.add(player);
                    }
                }
                players.add(player);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return players;
    }

    public void clearData() {
        if (this.datafile.exists()) {
            this.datafile.delete();
        }
    }

    public void spawnEffect(Location location, Particle particle) {
        Config config = this.plugin.getConfigObject();
        location.getWorld().spawnParticle(particle, location, config.getCount(), 0.5, 0.5, 0.5);
    }
}

