/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.velocitypowered.api.proxy.Player;
import io.github.irishgreencitrus.SourPlayer;
import io.github.irishgreencitrus.SourSettings;
import io.github.irishgreencitrus.gson_helpers.LocalDateTimeDeserializer;
import io.github.irishgreencitrus.gson_helpers.LocalDateTimeInstanceCreator;
import io.github.irishgreencitrus.gson_helpers.LocalDateTimeSerializer;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class SourServerState {
    public static final String PLAYERINFO_FILENAME = "playerinfo.json";
    public static final String SETTINGS_FILENAME = "settings.json";
    public SourSettings settings = new SourSettings();
    public HashMap<UUID, SourPlayer> playerInfo = new HashMap();
    private final Path dataDirectory;
    private final File playerInfoFile;
    private final File settingsFile;

    SourServerState(Path dataDirectory) {
        this.dataDirectory = dataDirectory;
        this.playerInfoFile = new File(dataDirectory.toFile(), PLAYERINFO_FILENAME);
        this.settingsFile = new File(dataDirectory.toFile(), SETTINGS_FILENAME);
        try {
            this.dataDirectory.toFile().mkdirs();
            if (!this.settingsFile.exists()) {
                this.settingsSaveToFile();
            } else {
                this.settingsLoadFromFile();
            }
            if (!this.playerInfoFile.exists()) {
                this.infoSaveToFile();
            } else {
                this.infoLoadFromFile();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean whitelistIsEnabled() {
        return this.settings.whitelistEnabled;
    }

    public void whitelistEnable() {
        this.settings.whitelistEnabled = true;
    }

    public void whitelistDisable() {
        this.settings.whitelistEnabled = false;
    }

    public boolean whitelistHas(Player player) {
        return this.whitelistHas(player.getUniqueId());
    }

    public boolean whitelistHas(UUID uuid) {
        if (!this.playerInfo.containsKey(uuid)) {
            return false;
        }
        return this.playerInfo.get((Object)uuid).permitted;
    }

    public boolean whitelistAdd(Player player) {
        return this.whitelistAdd(player.getUniqueId());
    }

    public boolean whitelistAdd(UUID uuid) {
        Optional<SourPlayer> sourPlayerOptional = this.getPlayer(uuid);
        if (sourPlayerOptional.isEmpty()) {
            return false;
        }
        SourPlayer sourPlayer = sourPlayerOptional.get();
        sourPlayer.permitted = true;
        return true;
    }

    public boolean whitelistRemove(Player player) {
        return this.whitelistRemove(player.getUniqueId());
    }

    public boolean whitelistRemove(UUID uuid) {
        Optional<SourPlayer> sourPlayerOptional = this.getPlayer(uuid);
        if (sourPlayerOptional.isEmpty()) {
            return false;
        }
        SourPlayer sourPlayer = sourPlayerOptional.get();
        sourPlayer.permitted = false;
        return true;
    }

    public List<SourPlayer> whitelistGetAllPermitted() {
        ArrayList<SourPlayer> sourPlayerArrayList = new ArrayList<SourPlayer>();
        for (SourPlayer sp : this.playerInfo.values()) {
            if (!sp.permitted) continue;
            sourPlayerArrayList.add(sp);
        }
        return sourPlayerArrayList;
    }

    @NotNull
    public Optional<SourPlayer> getPlayer(Player player) {
        return this.getPlayer(player.getUniqueId());
    }

    @NotNull
    public Optional<SourPlayer> getPlayer(UUID uuid) {
        if (!this.playerInfo.containsKey(uuid)) {
            return Optional.empty();
        }
        return Optional.of(this.playerInfo.get(uuid));
    }

    public boolean timeoutsEnabled() {
        return this.settings.timeoutsEnabled;
    }

    public void enableTimeouts() {
        this.settings.timeoutsEnabled = true;
    }

    public void disableTimeouts() {
        this.settings.timeoutsEnabled = false;
    }

    public void infoRegister(@NotNull Player player) {
        if (this.playerInfo.containsKey(player.getUniqueId())) {
            SourPlayer player1 = this.playerInfo.get(player.getUniqueId());
            player1.knownIPs.add(player.getRemoteAddress().getHostName());
            player1.uuid = player.getUniqueId();
            if (!player1.knownNames.contains(player.getUsername())) {
                player1.knownNames.add(player.getUsername());
            }
            player1.lastLogin = LocalDateTime.now();
        } else {
            SourPlayer player1 = new SourPlayer();
            player1.knownIPs.add(player.getRemoteAddress().getHostName());
            player1.knownNames.add(player.getUsername());
            player1.lastLogin = LocalDateTime.now();
            player1.uuid = player.getUniqueId();
            this.playerInfo.put(player.getUniqueId(), player1);
        }
    }

    public boolean infoIsRegistered(@NotNull Player player) {
        return this.infoIsRegistered(player.getUniqueId());
    }

    public boolean infoIsRegistered(@NotNull UUID uuid) {
        return this.playerInfo.containsKey(uuid);
    }

    public void infoSaveToFile() throws IOException {
        Gson g = this.getCustomGson();
        String info = g.toJson(this.playerInfo);
        FileWriter w = new FileWriter(this.playerInfoFile);
        w.write(info);
        w.close();
    }

    public void infoLoadFromFile() throws IOException {
        Gson g = this.getCustomGson();
        FileReader reader = new FileReader(this.playerInfoFile);
        TypeToken<HashMap<UUID, SourPlayer>> token = new TypeToken<HashMap<UUID, SourPlayer>>(){};
        this.playerInfo = (HashMap)g.fromJson((Reader)reader, (TypeToken)token);
        reader.close();
    }

    public void settingsSaveToFile() throws IOException {
        Gson g = this.getCustomGson();
        String info = g.toJson((Object)this.settings);
        FileWriter w = new FileWriter(this.settingsFile);
        w.write(info);
        w.close();
    }

    public void settingsLoadFromFile() throws IOException {
        Gson g = this.getCustomGson();
        FileReader reader = new FileReader(this.settingsFile);
        this.settings = (SourSettings)g.fromJson((Reader)reader, SourSettings.class);
        reader.close();
    }

    private Gson getCustomGson() {
        return new GsonBuilder().registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeDeserializer()).registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeSerializer()).registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeInstanceCreator()).setPrettyPrinting().setLenient().serializeNulls().create();
    }
}

