/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus;

import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.command.CommandMeta;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import io.github.irishgreencitrus.SourListener;
import io.github.irishgreencitrus.SourServerState;
import io.github.irishgreencitrus.SourWhitelistCommand;
import java.io.IOException;
import java.nio.file.Path;
import org.slf4j.Logger;

@Plugin(id="sourwhitelist", name="Sour Whitelist", version="0.1.0", authors={"irishgreencitrus"})
public final class SourWhitelist {
    private final SourServerState serverState;
    private final ProxyServer proxyServer;
    private final Logger logger;

    @Inject
    public SourWhitelist(ProxyServer proxyServer, Logger logger, @DataDirectory Path dataDirectory) {
        this.proxyServer = proxyServer;
        this.logger = logger;
        this.serverState = new SourServerState(dataDirectory);
    }

    @Subscribe
    public void onProxyInit(ProxyInitializeEvent event) {
        this.proxyServer.getEventManager().register((Object)this, (Object)new SourListener(this.logger, this.serverState));
        CommandManager commandManager = this.proxyServer.getCommandManager();
        CommandMeta commandMeta = commandManager.metaBuilder("sourwhitelist").aliases(new String[]{"swhitelist", "slist"}).plugin((Object)this).build();
        SourWhitelistCommand command = new SourWhitelistCommand(this.proxyServer, this.serverState);
        commandManager.register(commandMeta, (Command)command);
    }

    @Subscribe
    public void onProxyClose(ProxyShutdownEvent event) {
        try {
            this.serverState.infoSaveToFile();
            this.serverState.settingsSaveToFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

