/*
 * Decompiled with CFR 0.152.
 */
package io.github.irishgreencitrus;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import io.github.irishgreencitrus.SourPlayer;
import io.github.irishgreencitrus.SourServerState;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import net.kyori.adventure.text.Component;

public final class SourWhitelistCommand
implements SimpleCommand {
    private final ProxyServer server;
    private final SourServerState serverState;

    public SourWhitelistCommand(ProxyServer server, SourServerState serverState) {
        this.server = server;
        this.serverState = serverState;
    }

    public void execute(SimpleCommand.Invocation invocation) {
        CommandSource source = invocation.source();
        String[] args = (String[])invocation.arguments();
        if (args.length == 0) {
            source.sendMessage((Component)Component.text((String)"A subcommand is required"));
            source.sendMessage((Component)Component.text((String)"Usage: /sourwhitelist <subcommand> [args...]"));
            return;
        }
        switch (args[0]) {
            case "on": {
                this.serverState.whitelistEnable();
                source.sendMessage((Component)Component.text((String)"SourWhitelist Enabled"));
                break;
            }
            case "off": {
                this.serverState.whitelistDisable();
                source.sendMessage((Component)Component.text((String)"SourWhitelist Disabled"));
                break;
            }
            case "add": {
                if (args.length == 1) {
                    source.sendMessage((Component)Component.text((String)"Usage: /sourwhitelist add <players...>"));
                    return;
                }
                for (int i = 1; i < args.length; ++i) {
                    String name = args[i];
                    Optional optionalPlayer = this.server.getPlayer(name);
                    if (optionalPlayer.isEmpty()) {
                        source.sendMessage((Component)Component.text((String)("Cannot find player '" + name + "'")));
                        continue;
                    }
                    Player player = (Player)optionalPlayer.get();
                    this.serverState.whitelistAdd(player);
                    source.sendMessage((Component)Component.text((String)("Added player '" + name + "' to whitelist")));
                }
                break;
            }
            case "remove": {
                if (args.length == 1) {
                    source.sendMessage((Component)Component.text((String)"Usage: /sourwhitelist remove <players...>"));
                    return;
                }
                for (int i = 1; i < args.length; ++i) {
                    String name = args[i];
                    Optional optionalPlayer = this.server.getPlayer(name);
                    if (optionalPlayer.isEmpty()) {
                        source.sendMessage((Component)Component.text((String)("Cannot find player '" + name + "'")));
                        continue;
                    }
                    Player player = (Player)optionalPlayer.get();
                    this.serverState.whitelistRemove(player);
                }
                break;
            }
            case "list": {
                source.sendMessage((Component)Component.text((String)"Players on SourWhitelist:"));
                for (SourPlayer p : this.serverState.whitelistGetAllPermitted()) {
                    if (!p.knownNames.isEmpty()) {
                        source.sendMessage((Component)Component.text((String)p.knownNames.get(p.knownNames.size() - 1)));
                        continue;
                    }
                    source.sendMessage((Component)Component.text((String)("No name for: " + p.uuid)));
                }
                break;
            }
            case "load": {
                try {
                    this.serverState.infoLoadFromFile();
                    this.serverState.settingsLoadFromFile();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                source.sendMessage((Component)Component.text((String)"Loaded whitelist and info"));
                break;
            }
            case "save": {
                try {
                    this.serverState.infoSaveToFile();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                source.sendMessage((Component)Component.text((String)"Saved whitelist and info"));
                break;
            }
            case "help": {
                source.sendMessage((Component)Component.text((String)"SourWhitelist help.\n\ton\tTurn on the whitelist\n\toff\tTurn off the whitelist\n\tadd <player>\tAdd a player to the whitelist\n\tremove <player>\tRemove a player from the whitelist\n\tlist\tList all players on the whitelist\n\tload\tLoad the whitelist from whitelist.txt\n\tsave\tSave the current whitelist to whitelist.txt\n\thelp\tPrint this message"));
                break;
            }
            default: {
                source.sendMessage((Component)Component.text((String)"Subcommand is incorrect or incomplete"));
                source.sendMessage((Component)Component.text((String)"Usage: /sourwhitelist <subcommand> [args...]"));
            }
        }
    }

    public List<String> suggest(SimpleCommand.Invocation invocation) {
        String[] currentArgs = (String[])invocation.arguments();
        if (currentArgs.length == 1) {
            return List.of("on", "off", "add", "remove", "help", "list", "load", "save");
        }
        return List.of();
    }

    public boolean hasPermission(SimpleCommand.Invocation invocation) {
        return invocation.source().hasPermission("sour.whitelist_command");
    }
}

