/*
 * Decompiled with CFR 0.152.
 */
package com.knarfy.mclive.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;

public class MoobloomPollenParticle
extends TextureSheetParticle {
    private final SpriteSet spriteSet;

    public static MoobloomPollenParticleProvider provider(SpriteSet spriteSet) {
        return new MoobloomPollenParticleProvider(spriteSet);
    }

    protected MoobloomPollenParticle(ClientLevel world, double x, double y, double z, double vx, double vy, double vz, SpriteSet spriteSet) {
        super(world, x, y, z);
        this.spriteSet = spriteSet;
        this.setSize(0.1f, 0.1f);
        this.quadSize *= 0.18f;
        this.lifetime = Math.max(1, 40 + (this.random.nextInt(20) - 10));
        this.gravity = 0.01f;
        this.hasPhysics = false;
        this.xd = vx * 0.8;
        this.yd = vy * 0.8;
        this.zd = vz * 0.8;
        this.pickSprite(spriteSet);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void tick() {
        super.tick();
    }

    public static class MoobloomPollenParticleProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public MoobloomPollenParticleProvider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new MoobloomPollenParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

