/*
 * Decompiled with CFR 0.152.
 */
package com.knarfy.mclive.client.model;

import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class Modelhappy_creeper
extends EntityModel<LivingEntityRenderState> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"mclive", (String)"modelhappy_creeper"), "main");
    public final ModelPart body;
    public final ModelPart head;
    public final ModelPart leg_br;
    public final ModelPart leg_bl;
    public final ModelPart leg_fr;
    public final ModelPart leg_fl;

    public Modelhappy_creeper(ModelPart root) {
        super(root);
        this.body = root.getChild("body");
        this.head = this.body.getChild("head");
        this.leg_br = this.body.getChild("leg_br");
        this.leg_bl = this.body.getChild("leg_bl");
        this.leg_fr = this.body.getChild("leg_fr");
        this.leg_fl = this.body.getChild("leg_fl");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, -4.0f, -2.0f, 8.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)13.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
        PartDefinition eyebrow_r_r1 = head.addOrReplaceChild("eyebrow_r_r1", CubeListBuilder.create().texOffs(0, 26).mirror().addBox(-1.5f, -0.5f, 0.0f, 3.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-2.0f, (float)-7.0f, (float)-4.25f, (float)0.0f, (float)0.0f, (float)-0.1309f));
        PartDefinition eyebrow_l_r1 = head.addOrReplaceChild("eyebrow_l_r1", CubeListBuilder.create().texOffs(0, 26).addBox(-1.5f, -0.5f, 0.0f, 3.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)-7.0f, (float)-4.25f, (float)0.0f, (float)0.0f, (float)0.1309f));
        PartDefinition leg_br = body.addOrReplaceChild("leg_br", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, 0.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)5.0f, (float)2.0f));
        PartDefinition leg_bl = body.addOrReplaceChild("leg_bl", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, 0.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)5.0f, (float)2.0f));
        PartDefinition leg_fr = body.addOrReplaceChild("leg_fr", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -4.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)5.0f, (float)-2.0f));
        PartDefinition leg_fl = body.addOrReplaceChild("leg_fl", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -4.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)5.0f, (float)-2.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(LivingEntityRenderState state) {
        float limbSwing = state.walkAnimationPos;
        float limbSwingAmount = state.walkAnimationSpeed;
        float ageInTicks = state.ageInTicks;
        float netHeadYaw = state.yRot;
        float headPitch = state.xRot;
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.leg_bl.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.leg_fr.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.leg_br.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.leg_fl.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
    }
}

