/*
 * Decompiled with CFR 0.152.
 */
package com.knarfy.mclive.client.renderer.block;

import com.knarfy.mclive.block.TrappedCopperChestAnimatedBlock;
import com.knarfy.mclive.block.entity.TrappedCopperChestAnimatedBlockEntity;
import com.knarfy.mclive.client.model.Modeltrapped_copper_chest_Converted;
import com.knarfy.mclive.client.model.animations.trapped_copper_chest_ConvertedAnimation;
import com.knarfy.mclive.init.McliveModBlockEntities;
import com.knarfy.mclive.procedures.TrappedCopperChestPlaybackConditionProcedure;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.animation.KeyframeAnimation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import org.joml.Quaternionfc;

@EventBusSubscriber(value={Dist.CLIENT})
public class TrappedCopperChestAnimatedRenderer
implements BlockEntityRenderer<TrappedCopperChestAnimatedBlockEntity> {
    private final CustomHierarchicalModel model;
    private final ResourceLocation texture;
    private final LivingEntityRenderState renderState;

    TrappedCopperChestAnimatedRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new CustomHierarchicalModel(context.bakeLayer(Modeltrapped_copper_chest_Converted.LAYER_LOCATION));
        this.texture = ResourceLocation.parse((String)"mclive:textures/block/copper_trapped_chest.png");
        this.renderState = new LivingEntityRenderState();
    }

    private void updateRenderState(TrappedCopperChestAnimatedBlockEntity blockEntity, float partialTick) {
        int tickCount = (int)blockEntity.getLevel().getGameTime();
        this.renderState.ageInTicks = (float)tickCount + partialTick;
        blockEntity.animationState0.animateWhen(TrappedCopperChestPlaybackConditionProcedure.execute(blockEntity.getBlockState()), tickCount);
    }

    public void render(TrappedCopperChestAnimatedBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource renderer, int light, int overlayLight, Vec3 cameraPos) {
        this.updateRenderState(blockEntity, partialTick);
        poseStack.pushPose();
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.translate(-0.5, -0.5, 0.5);
        BlockState state = blockEntity.getBlockState();
        Direction facing = (Direction)state.getValue(TrappedCopperChestAnimatedBlock.FACING);
        switch (facing) {
            case NORTH: {
                break;
            }
            case EAST: {
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case WEST: {
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-90.0f));
                break;
            }
            case SOUTH: {
                poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
            }
        }
        poseStack.translate(0.0f, -1.0f, 0.0f);
        VertexConsumer builder = renderer.getBuffer(RenderType.entityCutout((ResourceLocation)this.texture));
        this.model.setupBlockEntityAnim(blockEntity, this.renderState);
        this.model.renderToBuffer(poseStack, builder, light, overlayLight);
        poseStack.popPose();
    }

    @SubscribeEvent
    public static void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)McliveModBlockEntities.TRAPPED_COPPER_CHEST_ANIMATED.get(), TrappedCopperChestAnimatedRenderer::new);
    }

    private static final class CustomHierarchicalModel
    extends Modeltrapped_copper_chest_Converted {
        private final KeyframeAnimation keyframeAnimation0;

        public CustomHierarchicalModel(ModelPart root) {
            super(root);
            this.keyframeAnimation0 = trapped_copper_chest_ConvertedAnimation.open.bake(root);
        }

        public void setupBlockEntityAnim(TrappedCopperChestAnimatedBlockEntity blockEntity, LivingEntityRenderState state) {
            this.root().getAllParts().forEach(ModelPart::resetPose);
            this.keyframeAnimation0.apply(blockEntity.animationState0, state.ageInTicks, 1.0f);
            super.setupAnim(state);
        }

        public ModelPart getRoot() {
            return this.root;
        }
    }
}

