/*
 * Decompiled with CFR 0.152.
 */
package com.knarfy.mclive.init;

import com.knarfy.mclive.entity.DeathStarBeamEntity;
import com.knarfy.mclive.entity.ElderGhastEntity;
import com.knarfy.mclive.entity.FireflyEntity;
import com.knarfy.mclive.entity.HappyCreeperEntity;
import com.knarfy.mclive.entity.MoobloomEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class McliveModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"mclive");
    public static final DeferredHolder<EntityType<?>, EntityType<MoobloomEntity>> MOOBLOOM = McliveModEntities.register("moobloom", EntityType.Builder.of(MoobloomEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.9f, 1.4f));
    public static final DeferredHolder<EntityType<?>, EntityType<FireflyEntity>> FIREFLY = McliveModEntities.register("firefly", EntityType.Builder.of(FireflyEntity::new, (MobCategory)MobCategory.CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<DeathStarBeamEntity>> DEATH_STAR_BEAM = McliveModEntities.register("death_star_beam", EntityType.Builder.of(DeathStarBeamEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<ElderGhastEntity>> ELDER_GHAST = McliveModEntities.register("elder_ghast", EntityType.Builder.of(ElderGhastEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(1.0f, 1.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<HappyCreeperEntity>> HAPPY_CREEPER = McliveModEntities.register("happy_creeper", EntityType.Builder.of(HappyCreeperEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.5f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mclive", (String)registryname))));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        MoobloomEntity.init(event);
        FireflyEntity.init(event);
        DeathStarBeamEntity.init(event);
        ElderGhastEntity.init(event);
        HappyCreeperEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)MOOBLOOM.get(), MoobloomEntity.createAttributes().build());
        event.put((EntityType)FIREFLY.get(), FireflyEntity.createAttributes().build());
        event.put((EntityType)DEATH_STAR_BEAM.get(), DeathStarBeamEntity.createAttributes().build());
        event.put((EntityType)ELDER_GHAST.get(), ElderGhastEntity.createAttributes().build());
        event.put((EntityType)HAPPY_CREEPER.get(), HappyCreeperEntity.createAttributes().build());
    }
}

