/*
 * Decompiled with CFR 0.152.
 */
package io.github.gaming32.bingo;

import com.demonwav.mcdev.annotations.Translatable;
import com.mojang.logging.LogUtils;
import io.github.gaming32.bingo.BingoCommand;
import io.github.gaming32.bingo.client.BingoConfig;
import io.github.gaming32.bingo.conditions.BingoConditions;
import io.github.gaming32.bingo.data.BingoDifficulty;
import io.github.gaming32.bingo.data.BingoRegistries;
import io.github.gaming32.bingo.data.BingoTag;
import io.github.gaming32.bingo.data.goal.GoalManager;
import io.github.gaming32.bingo.data.icons.GoalIconType;
import io.github.gaming32.bingo.data.progresstrackers.ProgressTrackerType;
import io.github.gaming32.bingo.data.subs.BingoSubType;
import io.github.gaming32.bingo.ext.MinecraftServerExt;
import io.github.gaming32.bingo.ext.ServerPlayerExt;
import io.github.gaming32.bingo.game.BingoGame;
import io.github.gaming32.bingo.game.mode.BingoGameMode;
import io.github.gaming32.bingo.game.persistence.PersistenceManager;
import io.github.gaming32.bingo.network.BingoNetworking;
import io.github.gaming32.bingo.network.messages.both.ManualHighlightPayload;
import io.github.gaming32.bingo.network.messages.configuration.ProtocolVersionConfigurationTask;
import io.github.gaming32.bingo.network.messages.configuration.ProtocolVersionPayload;
import io.github.gaming32.bingo.network.messages.s2c.InitBoardPayload;
import io.github.gaming32.bingo.network.messages.s2c.RemoveBoardPayload;
import io.github.gaming32.bingo.network.messages.s2c.ResyncStatesPayload;
import io.github.gaming32.bingo.network.messages.s2c.SyncTeamPayload;
import io.github.gaming32.bingo.network.messages.s2c.UpdateProgressPayload;
import io.github.gaming32.bingo.network.messages.s2c.UpdateStatePayload;
import io.github.gaming32.bingo.platform.BingoPlatform;
import io.github.gaming32.bingo.platform.event.Event;
import io.github.gaming32.bingo.subpredicates.BingoEntitySubPredicates;
import io.github.gaming32.bingo.triggers.BingoTriggers;
import io.github.gaming32.bingo.util.BingoUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraft.commands.Commands;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.scores.Scoreboard;
import org.slf4j.Logger;

public class Bingo {
    public static final String MOD_ID = "bingo";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final BingoConfig CONFIG = new BingoConfig(BingoPlatform.platform.getConfigDir().resolve("bingo.toml"));
    public static final LevelResource PERSISTED_BINGO_GAME = new LevelResource("persisted_bingo_game.dat");

    public static void init() {
        CONFIG.load();
        CONFIG.save();
        Bingo.registerEventHandlers();
        Bingo.initializeRegistries();
        Bingo.registerDatapackRegistries();
        Bingo.registerDataReloadListeners();
        Bingo.registerPayloadHandlers();
        LOGGER.info("I got the diagonal!");
    }

    private static void registerEventHandlers() {
        Event.REGISTER_COMMANDS.register(BingoCommand::register);
        Event.REGISTER_CONFIGURATION_TASKS.register(registrar -> {
            if (registrar.canSend(ProtocolVersionPayload.TYPE)) {
                registrar.addTask(ProtocolVersionConfigurationTask.INSTANCE);
            }
        });
        Event.PLAYER_JOIN.register(player -> {
            MinecraftServer server = player.level().getServer();
            BingoGame game = ((MinecraftServerExt)server).bingo$getGame();
            if (game != null) {
                game.addPlayer((ServerPlayer)player);
            }
        });
        Event.PLAYER_QUIT.register(player -> {
            MinecraftServer server = player.level().getServer();
            BingoGame game = ((MinecraftServerExt)server).bingo$getGame();
            if (game != null) {
                game.removePlayer((ServerPlayer)player);
            }
        });
        Event.COPY_PLAYER.register((from, to) -> ((ServerPlayerExt)from).bingo$copyAdvancementsNeedClearingTo((ServerPlayer)to));
        Event.RIGHT_CLICK_ITEM.register((player, hand) -> {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                BingoTriggers.TRY_USE_ITEM.get().trigger(serverPlayer, (InteractionHand)hand);
            }
        });
        Event.SERVER_EXPLOSION_START.register((level, explosion) -> {
            if (level instanceof ServerLevel) {
                ServerPlayer thePlayer;
                Entity patt1$temp;
                ServerPlayer thePlayer2;
                ServerLevel serverLevel = level;
                LivingEntity patt0$temp = explosion.getIndirectSourceEntity();
                Object player = patt0$temp instanceof ServerPlayer ? (thePlayer2 = (ServerPlayer)patt0$temp) : ((patt1$temp = explosion.getDamageSource().getEntity()) instanceof ServerPlayer ? (thePlayer = (ServerPlayer)patt1$temp) : null);
                if (player != null) {
                    BingoTriggers.EXPLOSION.get().trigger((ServerPlayer)player, serverLevel, (Explosion)explosion);
                }
            }
        });
        Event.SERVER_TICK_END.register(instance -> {
            BingoGame game = ((MinecraftServerExt)instance).bingo$getGame();
            if (game != null) {
                game.tick((MinecraftServer)instance);
            }
        });
        Event.SERVER_STARTED.register(instance -> {
            Path path = instance.getWorldPath(PERSISTED_BINGO_GAME);
            if (!Files.isRegularFile(path, new LinkOption[0])) {
                return;
            }
            LOGGER.info("Reading persisted Bingo game");
            try {
                CompoundTag tag = NbtIo.readCompressed((Path)path, (NbtAccounter)NbtAccounter.unlimitedHeap());
                ((MinecraftServerExt)instance).bingo$setGame(PersistenceManager.deserialize((HolderLookup.Provider)instance.registryAccess(), tag, (Scoreboard)instance.getScoreboard()));
                Files.deleteIfExists(path);
            }
            catch (Exception e) {
                LOGGER.error("Failed to load persisted Bingo game", (Throwable)e);
            }
        });
        Event.SERVER_STOPPING.register(instance -> {
            BingoGame game = ((MinecraftServerExt)instance).bingo$getGame();
            if (game == null) {
                return;
            }
            LOGGER.info("Storing persistent Bingo game");
            Path path = instance.getWorldPath(PERSISTED_BINGO_GAME);
            try {
                CompoundTag tag = PersistenceManager.serialize((HolderLookup.Provider)instance.registryAccess(), game);
                NbtIo.writeCompressed((CompoundTag)tag, (Path)path);
            }
            catch (Exception e) {
                LOGGER.error("Failed to store persistent Bingo game", (Throwable)e);
            }
        });
    }

    private static void initializeRegistries() {
        BingoGameMode.load();
        GoalIconType.load();
        ProgressTrackerType.load();
        BingoSubType.load();
        BingoConditions.load();
        BingoEntitySubPredicates.load();
        BingoTriggers.load();
    }

    private static void registerDatapackRegistries() {
        BingoPlatform.platform.registerDatapackRegistries(registrar -> {
            registrar.unsynced(BingoRegistries.TAG, BingoTag.CODEC);
            registrar.unsynced(BingoRegistries.DIFFICULTY, BingoDifficulty.CODEC);
        });
    }

    private static void registerDataReloadListeners() {
        BingoPlatform.platform.registerDataReloadListeners(registrar -> registrar.register(GoalManager.ID, GoalManager::new));
    }

    private static void registerPayloadHandlers() {
        BingoNetworking.instance().onRegister(registrar -> {
            registrar.register(ConnectionProtocol.CONFIGURATION, null, ProtocolVersionPayload.TYPE, ProtocolVersionPayload.CODEC, (payload, context) -> {
                switch (context.flow()) {
                    case CLIENTBOUND: {
                        payload.handleClientbound((BingoNetworking.Context)context);
                        break;
                    }
                    case SERVERBOUND: {
                        payload.handleServerbound((BingoNetworking.Context)context);
                    }
                }
            });
            registrar.register(PacketFlow.CLIENTBOUND, InitBoardPayload.TYPE, InitBoardPayload.CODEC);
            registrar.register(PacketFlow.CLIENTBOUND, RemoveBoardPayload.TYPE, RemoveBoardPayload.CODEC);
            registrar.register(PacketFlow.CLIENTBOUND, ResyncStatesPayload.TYPE, ResyncStatesPayload.CODEC);
            registrar.register(PacketFlow.CLIENTBOUND, SyncTeamPayload.TYPE, SyncTeamPayload.CODEC);
            registrar.register(PacketFlow.CLIENTBOUND, UpdateProgressPayload.TYPE, UpdateProgressPayload.CODEC);
            registrar.register(PacketFlow.CLIENTBOUND, UpdateStatePayload.TYPE, UpdateStatePayload.CODEC);
            registrar.register(null, ManualHighlightPayload.TYPE, ManualHighlightPayload.CODEC);
        });
    }

    public static void updateCommandTree(PlayerList playerList) {
        playerList.getPlayers().forEach(arg_0 -> ((Commands)playerList.getServer().getCommands()).sendCommands(arg_0));
    }

    public static MutableComponent translatable(@Translatable String key, Object ... args) {
        return BingoUtil.ensureHasFallback(Component.translatable((String)key, (Object[])args));
    }

    public static MutableComponent translatableEscape(@Translatable(allowArbitraryArgs=true) String key, Object ... args) {
        return BingoUtil.ensureHasFallback(Component.translatableEscape((String)key, (Object[])args));
    }

    public static boolean isInstalledOnClient(ServerPlayer player) {
        return BingoNetworking.instance().canPlayerReceive(player, InitBoardPayload.TYPE);
    }
}

